/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import org.noear.solon.serialization.prop.JsonProps;

public class NullValueSerializer
extends JsonSerializer<Object> {
    private JsonProps jsonProps;
    public Class<?> type0;

    public NullValueSerializer(JsonProps jsonProps) {
        this.jsonProps = jsonProps;
    }

    public NullValueSerializer(JsonProps jsonProps, JavaType type) {
        this.jsonProps = jsonProps;
        this.type0 = type == null ? Object.class : type.getRawClass();
    }

    public void serialize(Object o, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        Class<?> type = this.type0;
        if (type == null) {
            try {
                if (gen.getCurrentValue() != null) {
                    String fieldName = gen.getOutputContext().getCurrentName();
                    Field field = gen.getCurrentValue().getClass().getDeclaredField(fieldName);
                    type = field.getType();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (type != null) {
            if (this.jsonProps.nullStringAsEmpty && type == String.class) {
                gen.writeString("");
                return;
            }
            if (this.jsonProps.nullBoolAsFalse && type == Boolean.class) {
                if (this.jsonProps.boolAsInt) {
                    gen.writeNumber(0);
                } else {
                    gen.writeBoolean(false);
                }
                return;
            }
            if (this.jsonProps.nullNumberAsZero && Number.class.isAssignableFrom(type)) {
                if (this.jsonProps.longAsString && type == Long.class) {
                    gen.writeString("0");
                } else if (type == Long.class) {
                    gen.writeNumber(0L);
                } else if (type == Double.class) {
                    gen.writeNumber(0.0);
                } else if (type == Float.class) {
                    gen.writeNumber(0.0f);
                } else {
                    gen.writeNumber(0);
                }
                return;
            }
            if (this.jsonProps.nullArrayAsEmpty && (Collection.class.isAssignableFrom(type) || type.isArray())) {
                gen.writeStartArray();
                gen.writeEndArray();
                return;
            }
        }
        gen.writeNull();
    }
}

