/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.noear.solon.Solon;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ActionExecutor;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.jackson.JacksonActionExecutor;
import org.noear.solon.serialization.jackson.JacksonRenderFactory;
import org.noear.solon.serialization.jackson.JacksonRenderTypedFactory;
import org.noear.solon.serialization.jackson.NullValueSerializer;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;

public class XPluginImp
implements Plugin {
    public static boolean output_meta = false;

    public void start(AopContext context) {
        output_meta = Solon.cfg().getInt("solon.output.meta", 0) > 0;
        JsonProps jsonProps = JsonProps.create((AopContext)context);
        JacksonRenderFactory renderFactory = new JacksonRenderFactory();
        this.applyProps(renderFactory, jsonProps);
        context.wrapAndPut(JacksonRenderFactory.class, (Object)renderFactory);
        EventBus.push((Object)renderFactory);
        JacksonRenderTypedFactory renderTypedFactory = new JacksonRenderTypedFactory();
        context.wrapAndPut(JacksonRenderTypedFactory.class, (Object)renderTypedFactory);
        context.lifecycle(() -> {
            RenderManager.mapping((String)"@json", (Render)renderFactory.create());
            RenderManager.mapping((String)"@type_json", (Render)renderTypedFactory.create());
        });
        JacksonActionExecutor actionExecutor = new JacksonActionExecutor();
        context.wrapAndPut(JacksonActionExecutor.class, (Object)actionExecutor);
        EventBus.push((Object)((Object)actionExecutor));
        Bridge.actionExecutorAdd((ActionExecutor)actionExecutor);
    }

    private void applyProps(JacksonRenderFactory factory, JsonProps jsonProps) {
        boolean writeNulls = false;
        if (JsonPropsUtil.apply((JsonRenderFactory)factory, (JsonProps)jsonProps)) {
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (writeNulls) {
                factory.config().getSerializerProvider().setNullValueSerializer((JsonSerializer)new NullValueSerializer(jsonProps));
            }
        }
        if (!writeNulls) {
            factory.config().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        factory.config().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        factory.config().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        factory.config().configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
    }
}

