/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Render;
import org.noear.solon.serialization.jackson.XPluginImp;

public class JacksonRender
implements Render {
    ObjectMapper mapper = new ObjectMapper();
    ObjectMapper mapper_serialize = new ObjectMapper();
    private boolean _typedJson;

    public JacksonRender(boolean typedJson) {
        this._typedJson = typedJson;
        this.mapper.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper_serialize.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public void render(Object obj, Context ctx) throws Throwable {
        String txt = null;
        if (this._typedJson) {
            txt = this.mapper_serialize.writeValueAsString(obj);
        } else if (ctx.accept().indexOf("/json") > 0) {
            txt = this.mapper.writeValueAsString(obj);
        } else {
            if (obj == null) {
                return;
            }
            if (obj instanceof Throwable) {
                throw (Throwable)obj;
            }
            if (obj instanceof String && ctx.accept().indexOf("/json") < 0) {
                ctx.output((String)obj);
                return;
            }
            txt = this.mapper.writeValueAsString(obj);
        }
        if (XPluginImp.output_meta) {
            ctx.headerSet("solon.serialization", "JacksonRender");
        }
        ctx.attrSet("output", (Object)txt);
        ctx.outputAsJson(txt);
    }
}

