/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.gson;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.noear.solon.Solon;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.gson.GsonActionExecutor;
import org.noear.solon.serialization.gson.GsonDateSerialize;
import org.noear.solon.serialization.gson.GsonRenderFactory;
import org.noear.solon.serialization.gson.GsonRenderTypedFactory;
import org.noear.solon.serialization.gson.impl.EnumAdapter;
import org.noear.solon.serialization.gson.impl.NullArraySerialize;
import org.noear.solon.serialization.gson.impl.NullBooleanAdapter;
import org.noear.solon.serialization.gson.impl.NullCollectionSerialize;
import org.noear.solon.serialization.gson.impl.NullLongAdapter;
import org.noear.solon.serialization.gson.impl.NullNumberSerialize;
import org.noear.solon.serialization.gson.impl.NullStringSerialize;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;

public class XPluginImp
implements Plugin {
    public void start(AopContext context) {
        JsonProps jsonProps = JsonProps.create((AopContext)context);
        GsonRenderFactory renderFactory = new GsonRenderFactory();
        this.applyProps(renderFactory, jsonProps);
        context.wrapAndPut(GsonRenderFactory.class, (Object)renderFactory);
        EventBus.publish((Object)renderFactory);
        GsonRenderTypedFactory renderTypedFactory = new GsonRenderTypedFactory();
        context.wrapAndPut(GsonRenderTypedFactory.class, (Object)renderTypedFactory);
        context.lifecycle(-99, () -> {
            RenderManager.mapping((String)"@json", (Render)renderFactory.create());
            RenderManager.mapping((String)"@type_json", (Render)renderTypedFactory.create());
        });
        GsonActionExecutor actionExecutor = new GsonActionExecutor();
        context.wrapAndPut(GsonActionExecutor.class, (Object)actionExecutor);
        EventBus.publish((Object)((Object)actionExecutor));
        Solon.app().chainManager().addExecuteHandler((ActionExecuteHandler)actionExecutor);
    }

    private void applyProps(GsonRenderFactory factory, JsonProps jsonProps) {
        boolean writeNulls = false;
        if (JsonPropsUtil.apply((JsonRenderFactory)factory, (JsonProps)jsonProps)) {
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (writeNulls) {
                factory.config().serializeNulls();
            }
            if (jsonProps.nullNumberAsZero) {
                factory.config().registerTypeAdapter(Short.class, new NullNumberSerialize());
                factory.config().registerTypeAdapter(Integer.class, new NullNumberSerialize());
                factory.config().registerTypeAdapter(Long.class, (Object)new NullLongAdapter(jsonProps));
                factory.config().registerTypeAdapter(Float.class, new NullNumberSerialize());
                factory.config().registerTypeAdapter(Double.class, new NullNumberSerialize());
            }
            if (jsonProps.nullArrayAsEmpty) {
                factory.config().registerTypeAdapter(Collection.class, (Object)new NullCollectionSerialize());
                factory.config().registerTypeAdapter(Arrays.class, (Object)new NullArraySerialize());
            }
            if (jsonProps.nullBoolAsFalse) {
                factory.config().registerTypeAdapter(Boolean.class, (Object)new NullBooleanAdapter(jsonProps));
            }
            if (jsonProps.nullStringAsEmpty) {
                factory.config().registerTypeAdapter(String.class, (Object)new NullStringSerialize());
            }
            if (jsonProps.enumAsName) {
                factory.config().registerTypeAdapter(Enum.class, (Object)new EnumAdapter());
            }
        } else {
            factory.config().registerTypeAdapter(Date.class, (Object)new GsonDateSerialize());
        }
    }
}

