/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Date;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Render;
import org.noear.solon.serialization.gson.GsonDateSerialize;
import org.noear.solon.serialization.gson.XPluginImp;

public class GsonRender
implements Render {
    Gson stringify = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new GsonDateSerialize()).create();
    Gson serialize = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new GsonDateSerialize()).create();
    private boolean _typedJson;

    public GsonRender(boolean typedJson) {
        this._typedJson = typedJson;
    }

    public void render(Object obj, Context ctx) throws Throwable {
        String txt = null;
        if (this._typedJson) {
            txt = this.serialize.toJson(obj, obj.getClass());
        } else {
            if (obj == null) {
                return;
            }
            if (obj instanceof Throwable) {
                throw (Throwable)obj;
            }
            txt = obj instanceof String ? (String)obj : this.stringify.toJson(obj);
        }
        if (XPluginImp.output_meta) {
            ctx.headerSet("solon.serialization", "GsonRender");
        }
        ctx.attrSet("output", (Object)txt);
        if (obj instanceof String && !ctx.accept().contains("/json")) {
            ctx.output(txt);
        } else {
            ctx.outputAsJson(txt);
        }
    }
}

