/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeWriter;
import java.lang.reflect.Type;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.serialization.JsonRenderFactory;

public abstract class FastjsonRenderFactoryBase
implements JsonRenderFactory {
    public abstract SerializeConfig config();

    public void addEncoder(Type clz, ObjectSerializer encoder) {
        this.config().put(clz, encoder);
        if (clz == Long.class) {
            this.config().put(Long.TYPE, encoder);
        } else if (clz == Integer.class) {
            this.config().put(Integer.TYPE, encoder);
        }
    }

    public <T> void addConvertor(Class<T> clz, Converter<T, Object> converter) {
        this.addEncoder(clz, (ser, obj, fieldName, fieldType, features) -> {
            Object val = converter.convert(obj);
            SerializeWriter out = ser.getWriter();
            if (val == null) {
                out.writeNull();
            } else if (val instanceof String) {
                out.writeString((String)val);
            } else if (val instanceof Number) {
                if (val instanceof Integer || val instanceof Long) {
                    out.writeLong(((Number)val).longValue());
                } else {
                    out.writeDouble(((Number)val).doubleValue(), false);
                }
            } else {
                throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
            }
        });
    }
}

