/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.scheduled.manager;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.scheduling.ScheduledException;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.scheduled.JobHandler;
import org.noear.solon.scheduling.scheduled.JobHolder;
import org.noear.solon.scheduling.scheduled.manager.IJobManager;

public abstract class AbstractJobManager
implements IJobManager {
    protected Map<String, JobHolder> jobMap = new HashMap<String, JobHolder>();
    protected boolean isStarted = false;

    @Override
    public JobHolder jobAdd(String name, Scheduled scheduled, JobHandler handler) {
        JobHolder jobHolder;
        this.jobAddCheckDo(name, scheduled);
        if (this.jobExists(name)) {
            jobHolder = this.jobMap.get(name);
        } else {
            jobHolder = this.jobWrapDo(name, scheduled, handler);
            this.jobMap.put(name, jobHolder);
        }
        if (this.isStarted()) {
            this.jobStart(name, null);
        }
        return jobHolder;
    }

    protected JobHolder jobWrapDo(String name, Scheduled scheduled, JobHandler handler) {
        return new JobHolder(name, scheduled, handler);
    }

    protected void jobAddCheckDo(String name, Scheduled scheduled) {
        if (Utils.isEmpty((String)name)) {
            throw new IllegalArgumentException("The job name cannot be empty!");
        }
        if (scheduled.fixedDelay() > 0L && scheduled.fixedRate() > 0L) {
            if (Utils.isEmpty((String)scheduled.cron())) {
                throw new IllegalArgumentException("The job fixedDelay and fixedRate cannot both have values: " + name);
            }
            throw new IllegalArgumentException("The job cron and fixedDelay and fixedRate cannot both have values: " + name);
        }
    }

    @Override
    public boolean jobExists(String name) {
        return this.jobMap.containsKey(name);
    }

    @Override
    public JobHolder jobGet(String name) {
        return this.jobMap.get(name);
    }

    @Override
    public Map<String, JobHolder> jobGetAll() {
        return this.jobMap;
    }

    @Override
    public void jobRemove(String name) throws ScheduledException {
        this.jobStop(name);
        this.jobMap.remove(name);
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }
}

