/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.retry;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.noear.solon.scheduling.retry.Callee;
import org.noear.solon.scheduling.retry.Recover;

public class RetryableTask<T> {
    private final Set<Class<? extends Throwable>> exceptionIncludes = new HashSet<Class<? extends Throwable>>();
    private final Set<Class<? extends Throwable>> exceptionExcludes = new HashSet<Class<? extends Throwable>>();
    private long maxRetryCount = 3L;
    private long interval = 1L;
    private TimeUnit unit = TimeUnit.SECONDS;
    private Recover<T> recover;
    private T result;
    private final Callee callee;

    private RetryableTask(Callee callee) {
        this.callee = callee;
    }

    public static RetryableTask<Void> of(Callee task) {
        return new RetryableTask<Void>(task);
    }

    public RetryableTask<T> maxRetryCount(long maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
    }

    public RetryableTask<T> interval(long interval) {
        this.interval = interval;
        return this;
    }

    public RetryableTask<T> unit(TimeUnit unit) {
        this.unit = unit;
        return this;
    }

    public final RetryableTask<T> retryForIncludes(Class<? extends Throwable> ... exs) {
        if (exs != null && exs.length > 0) {
            this.exceptionIncludes.addAll(Arrays.asList(exs));
        }
        return this;
    }

    public final RetryableTask<T> retryForExcludes(Class<? extends Throwable> ... exs) {
        if (exs != null && exs.length > 0) {
            this.exceptionExcludes.addAll(Arrays.asList(exs));
        }
        return this;
    }

    public RetryableTask<T> recover(Recover<T> recover) {
        this.recover = recover;
        return this;
    }

    public T get() {
        return this.result;
    }

    public RetryableTask<T> execute() throws Throwable {
        if (this.callee == null) {
            throw new IllegalArgumentException("task parameter cannot be null");
        }
        if (this.unit == null) {
            throw new IllegalArgumentException("delay parameter cannot be null");
        }
        if (this.interval < 0L) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        this.executeDo();
        return this;
    }

    private boolean retryPredicate(Throwable e) {
        if (this.exceptionExcludes.size() > 0 && this.exceptionExcludes.stream().anyMatch(ex -> ex.isAssignableFrom(e.getClass()))) {
            return false;
        }
        if (this.exceptionIncludes.size() > 0) {
            return this.exceptionIncludes.stream().anyMatch(ex -> ex.isAssignableFrom(e.getClass()));
        }
        return true;
    }

    private void executeDo() throws Throwable {
        Throwable throwable = null;
        while (--this.maxRetryCount >= 0L) {
            try {
                this.result = this.callee.call();
                return;
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                throwable = e;
                if (this.retryPredicate(e)) {
                    try {
                        this.unit.sleep(this.interval);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw e;
            }
        }
        if (this.recover != null) {
            this.result = this.recover.recover(this.callee, throwable);
        }
    }
}

