/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.retry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.noear.solon.scheduling.retry.Recover;

public class RetryableTask<T> {
    private final List<Class<? extends Throwable>> exs = new ArrayList<Class<? extends Throwable>>();
    private T result;
    private final Supplier<T> sup;
    private long maxRetryCount;
    private long interval;
    private TimeUnit unit;
    private Recover<T> recover;
    private BiPredicate<T, Throwable> predicate;

    private RetryableTask(Runnable run) {
        this.sup = () -> {
            run.run();
            return null;
        };
    }

    private RetryableTask(Supplier<T> sup) {
        this.sup = sup;
    }

    public static RetryableTask<Void> of(Runnable run) {
        return new RetryableTask<Void>(run);
    }

    public static <T> RetryableTask<T> of(Supplier<T> sup) {
        return new RetryableTask<T>(sup);
    }

    public RetryableTask<T> maxRetryCount(long maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
    }

    public RetryableTask<T> interval(long interval) {
        this.interval = interval;
        return this;
    }

    public RetryableTask<T> unit(TimeUnit unit) {
        this.unit = unit;
        return this;
    }

    @SafeVarargs
    public final RetryableTask<T> retryForExceptions(Class<? extends Throwable> ... exs) {
        this.exs.addAll(Arrays.asList(exs));
        return this;
    }

    public final RetryableTask<T> retryForPredicate(BiPredicate<T, Throwable> predicate) {
        this.predicate = predicate;
        return this;
    }

    public RetryableTask<T> recover(Recover<T> recover) {
        this.recover = recover;
        return this;
    }

    public T get() {
        return this.result;
    }

    public CompletableFuture<RetryableTask<T>> asyncExecute() {
        return CompletableFuture.supplyAsync(this::execute);
    }

    public RetryableTask<T> execute() {
        if (this.sup == null) {
            throw new IllegalArgumentException("task parameter cannot be null");
        }
        if (this.unit == null) {
            throw new IllegalArgumentException("delay parameter cannot be null");
        }
        if (this.interval < 0L) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        if (this.predicate != null) {
            this.retryPHelper();
        } else if (!this.exs.isEmpty()) {
            if (this.maxRetryCount < 0L) {
                throw new IllegalArgumentException("maxRetryCount must be greater than 0");
            }
            this.retryEHelper();
        } else {
            throw new IllegalArgumentException("predicate and exs cannot both be empty");
        }
        return this;
    }

    private void retryPHelper() {
        block5: {
            Exception ex = null;
            while (true) {
                try {
                    this.result = this.sup.get();
                }
                catch (Exception e) {
                    ex = e;
                }
                if (!Boolean.TRUE.equals(this.predicate.test(this.result, ex))) break;
                try {
                    this.unit.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.recover == null) break block5;
            this.result = this.recover.recover();
        }
    }

    private void retryEHelper() {
        while (--this.maxRetryCount >= 0L) {
            try {
                this.result = this.sup.get();
                return;
            }
            catch (Exception e) {
                if (!this.exs.stream().anyMatch(ex -> ex.isAssignableFrom(e.getClass()))) break;
                try {
                    this.unit.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.recover != null) {
            this.result = this.recover.recover();
        }
    }
}

