/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.utils;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.Props;
import org.noear.solon.scheduling.ScheduledAnno;

public class ScheduledHelper {
    public static void resetScheduled(ScheduledAnno warpper) {
        if (warpper.cron().length() < 6 || warpper.cron().indexOf(" ") < 0) {
            warpper.fixedRate(ScheduledHelper.fixedRate(warpper.cron()));
            warpper.cron("");
        } else {
            warpper.fixedRate(0L);
        }
    }

    public static void configScheduled(ScheduledAnno warpper) {
        Props prop;
        if (warpper.cron().length() < 6 || warpper.cron().indexOf(" ") < 0) {
            if (warpper.fixedRate() == 0L) {
                warpper.fixedRate(ScheduledHelper.fixedRate(warpper.cron()));
            }
            warpper.cron("");
        }
        if (Utils.isNotEmpty((String)warpper.name()) && (prop = Solon.cfg().getProp("solon.scheduling." + warpper.name())).size() > 0) {
            String cronTmp = prop.getProperty("cron");
            String enableTmp = prop.getProperty("enable");
            if ("false".equals(enableTmp)) {
                warpper.enable(false);
            }
            if (Utils.isNotEmpty((String)cronTmp)) {
                if (cronTmp.length() > 6 && cronTmp.contains(" ")) {
                    warpper.cron(cronTmp);
                } else {
                    warpper.fixedRate(ScheduledHelper.fixedRate(cronTmp));
                }
            }
        }
    }

    public static long fixedRate(String cronx) {
        if (cronx.endsWith("ms")) {
            long period = Long.parseLong(cronx.substring(0, cronx.length() - 2));
            return period;
        }
        if (cronx.endsWith("s")) {
            long period = Long.parseLong(cronx.substring(0, cronx.length() - 1));
            return period * 1000L;
        }
        if (cronx.endsWith("m")) {
            long period = Long.parseLong(cronx.substring(0, cronx.length() - 1));
            return period * 1000L * 60L;
        }
        if (cronx.endsWith("h")) {
            long period = Long.parseLong(cronx.substring(0, cronx.length() - 1));
            return period * 1000L * 60L * 60L;
        }
        if (cronx.endsWith("d")) {
            long period = Long.parseLong(cronx.substring(0, cronx.length() - 1));
            return period * 1000L * 60L * 60L * 24L;
        }
        return 0L;
    }
}

