/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.simple;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.simple.JobHolder;

public class JobManager {
    private static Map<String, JobHolder> jobEntityMap = new HashMap<String, JobHolder>();
    private static boolean isStarted = false;

    public static void add(String name, Scheduled anno, Runnable runnable) {
        if (!anno.enable()) {
            return;
        }
        if (Utils.isEmpty((String)name)) {
            throw new IllegalArgumentException("The job name cannot be empty!");
        }
        if (anno.fixedDelay() > 0L && anno.fixedRate() > 0L) {
            if (Utils.isEmpty((String)anno.cron())) {
                throw new IllegalArgumentException("The job fixedDelay and fixedRate cannot both have values: " + name);
            }
            throw new IllegalArgumentException("The job cron and fixedDelay and fixedRate cannot both have values: " + name);
        }
        JobManager.addDo(name, new JobHolder(name, anno, runnable));
    }

    private static void addDo(String name, JobHolder jobEntity) {
        jobEntityMap.putIfAbsent(name, jobEntity);
        if (isStarted) {
            jobEntity.start();
        }
    }

    public static int count() {
        return jobEntityMap.size();
    }

    public static boolean contains(String name) {
        return jobEntityMap.containsKey(name);
    }

    public static void remove(String name) {
        JobHolder jobHolder = jobEntityMap.get(name);
        if (jobHolder != null) {
            jobHolder.cancel();
            jobEntityMap.remove(name);
        }
    }

    public static void start() {
        for (JobHolder job : jobEntityMap.values()) {
            job.start();
        }
        isStarted = true;
    }

    public static void stop() {
        for (JobHolder job : jobEntityMap.values()) {
            job.cancel();
        }
        isStarted = false;
    }
}

