/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.simple.cron;

import java.text.ParseException;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.noear.solon.scheduling.simple.cron.CronExpressionPlus;

public class CronUtils {
    private static Map<String, CronExpressionPlus> cached = new HashMap<String, CronExpressionPlus>();

    public static CronExpressionPlus get(String cron) {
        try {
            return CronUtils.get0(cron);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cron parsing failed: " + cron, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CronExpressionPlus get0(String cron) throws ParseException {
        CronExpressionPlus expr = cached.get(cron);
        if (expr == null) {
            String string = cron.intern();
            synchronized (string) {
                expr = cached.get(cron);
                if (expr == null) {
                    int tzIdx = cron.indexOf("+");
                    if (tzIdx < 0) {
                        tzIdx = cron.indexOf("-");
                    }
                    if (tzIdx > 0) {
                        String tz = cron.substring(tzIdx);
                        ZoneOffset tz2 = ZoneOffset.of(tz);
                        cron = cron.substring(0, tzIdx - 1);
                        expr = new CronExpressionPlus(cron);
                        expr.setTimeZone(TimeZone.getTimeZone(tz2));
                    } else {
                        expr = new CronExpressionPlus(cron);
                    }
                    cached.put(cron, expr);
                }
            }
        }
        return expr;
    }

    public static Date getNextTime(String cron, Date baseTime) throws ParseException {
        return CronUtils.get(cron).getNextValidTimeAfter(baseTime);
    }

    public static boolean isValid(String cron) {
        try {
            return CronUtils.get0(cron) != null;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

