/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.listener;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketListener;

public class PipelineWebSocketListener
implements WebSocketListener {
    protected final Deque<WebSocketListener> pipeline = new LinkedList<WebSocketListener>();
    protected final Set<Class<?>> typeSet = new HashSet();

    public PipelineWebSocketListener prev(WebSocketListener listener) {
        this.pipeline.addFirst(listener);
        return this;
    }

    public PipelineWebSocketListener prevIfAbsent(WebSocketListener listener) {
        if (!this.typeSet.contains(listener.getClass())) {
            this.typeSet.add(listener.getClass());
            this.pipeline.addFirst(listener);
        }
        return this;
    }

    public PipelineWebSocketListener next(WebSocketListener listener) {
        this.pipeline.addLast(listener);
        return this;
    }

    public PipelineWebSocketListener nextIfAbsent(WebSocketListener listener) {
        if (!this.typeSet.contains(listener.getClass())) {
            this.typeSet.add(listener.getClass());
            this.pipeline.addLast(listener);
        }
        return this;
    }

    @Override
    public void onOpen(WebSocket socket) {
        for (WebSocketListener listener : this.pipeline) {
            listener.onOpen(socket);
        }
    }

    @Override
    public void onMessage(WebSocket socket, String text) throws IOException {
        for (WebSocketListener listener : this.pipeline) {
            listener.onMessage(socket, text);
        }
    }

    @Override
    public void onMessage(WebSocket socket, ByteBuffer binary) throws IOException {
        for (WebSocketListener listener : this.pipeline) {
            listener.onMessage(socket, binary);
        }
    }

    @Override
    public void onClose(WebSocket socket) {
        for (WebSocketListener listener : this.pipeline) {
            listener.onClose(socket);
        }
    }

    @Override
    public void onError(WebSocket socket, Throwable error) {
        for (WebSocketListener listener : this.pipeline) {
            listener.onError(socket, error);
        }
    }
}

