/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.integration;

import org.noear.socketd.transport.core.Listener;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.net.annotation.ServerEndpoint;
import org.noear.solon.net.socketd.SocketdRouter;
import org.noear.solon.net.websocket.WebSocketListener;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPluginImpl
implements Plugin {
    static final Logger log = LoggerFactory.getLogger(XPluginImpl.class);
    private final SocketdRouter socketdRouter = SocketdRouter.getInstance();
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public void start(AppContext context) throws Throwable {
        context.wrapAndPut(WebSocketRouter.class, (Object)this.webSocketRouter);
        context.wrapAndPut(SocketdRouter.class, (Object)this.socketdRouter);
        context.beanBuilderAdd(ServerEndpoint.class, this::serverEndpointBuild);
    }

    private void serverEndpointBuild(Class<?> clz, BeanWrap bw, ServerEndpoint anno) {
        String path = anno.value();
        boolean registered = false;
        if (bw.raw() instanceof Listener) {
            if (Utils.isEmpty((String)path)) {
                path = "**";
            }
            this.socketdRouter.of(path, (Listener)bw.raw());
            registered = true;
        }
        if (bw.raw() instanceof WebSocketListener) {
            if (Utils.isEmpty((String)path)) {
                path = "**";
            }
            this.webSocketRouter.of(path, (WebSocketListener)bw.raw());
            registered = true;
        }
        if (!registered) {
            log.warn("@ServerEndpoint does not support type: {}", (Object)clz.getName());
        }
    }
}

