/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging.integration.log4j;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.noear.solon.logging.AppenderManager;
import org.noear.solon.logging.event.Level;
import org.noear.solon.logging.event.LogEvent;

public class SolonAppender
extends AppenderSkeleton {
    protected void append(LoggingEvent e) {
        Level level = Level.INFO;
        switch (e.getLevel().toInt()) {
            case 5000: {
                level = Level.TRACE;
                break;
            }
            case 10000: {
                level = Level.DEBUG;
                break;
            }
            case 30000: {
                level = Level.WARN;
                break;
            }
            case 40000: 
            case 50000: {
                level = Level.ERROR;
            }
        }
        ThrowableInformation tmp = e.getThrowableInformation();
        LogEvent event = new LogEvent(e.getLoggerName(), level, e.getProperties(), e.getMessage(), e.getTimeStamp(), e.getThreadName(), tmp == null ? null : tmp.getThrowable());
        AppenderManager.getInstance().append(event);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

