/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.solon.integration;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.fusesource.jansi.AnsiConsole;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.JavaUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.logging.LogIncubator;
import org.noear.solon.logging.LogOptions;
import org.noear.solon.logging.model.LoggerLevelEntity;

public class LogIncubatorImpl
implements LogIncubator {
    public void incubate() throws Throwable {
        if (JavaUtil.IS_WINDOWS && !Solon.cfg().isFilesMode() && ClassUtil.hasClass(() -> AnsiConsole.class)) {
            try {
                AnsiConsole.systemInstall();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        ThreadContext.put((String)"pid", (String)System.getProperty("PID"));
        URL url = this.getUrlOfConfig();
        if (url == null && ResourceUtil.hasResource((String)"log4j2.xml")) {
            return;
        }
        if (url == null && Utils.isNotEmpty((String)Solon.cfg().env())) {
            url = ResourceUtil.getResource((String)("log4j2-solon-" + Solon.cfg().env() + ".xml"));
        }
        if (url == null) {
            url = ResourceUtil.getResource((String)"log4j2-solon.xml");
        }
        if (url == null) {
            boolean fileEnable = Solon.cfg().getBool("solon.logging.appender.file.enable", true);
            url = fileEnable ? ResourceUtil.getResource((String)"META-INF/solon_def/log4j2-def.xml") : ResourceUtil.getResource((String)"META-INF/solon_def/log4j2-def_nofile.xml");
        }
        this.initDo(url);
    }

    private void initDo(URL url) {
        if (url == null) {
            return;
        }
        try {
            Configurator.reconfigure((URI)url.toURI());
            if (LogOptions.getLoggerLevels().size() > 0) {
                LoggerContext context = LoggerContext.getContext((boolean)false);
                for (LoggerLevelEntity lle : LogOptions.getLoggerLevels()) {
                    LoggerConfig logger = new LoggerConfig(lle.getLoggerExpr(), Level.valueOf((String)lle.getLevel().name()), true);
                    context.getConfiguration().addLogger(logger.getName(), logger);
                }
                context.updateLoggers();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private URL getUrlOfConfig() throws MalformedURLException {
        String logConfig = Solon.cfg().get("solon.logging.config");
        if (Utils.isNotEmpty((String)logConfig)) {
            File logConfigFile = new File(logConfig);
            if (logConfigFile.exists()) {
                return logConfigFile.toURI().toURL();
            }
            LogUtil.global().warn("Props: No log config file: " + logConfig);
        }
        return null;
    }
}

