/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.openapi2;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.docs.DocDocket;

public class BasicAuthUtils {
    static final Charset UTF_8 = Charset.forName("UTF-8");

    public static String base64DecodeToStr(String value) {
        byte[] decodedValue = Base64.getDecoder().decode(value);
        return new String(decodedValue, UTF_8);
    }

    public static boolean basicAuth(Context ctx, DocDocket docket) throws IOException {
        if (docket.basicAuth() == null || docket.basicAuth().size() == 0) {
            return true;
        }
        String authorization = ctx.header("Authorization");
        if (Utils.isBlank((String)authorization)) {
            return false;
        }
        String nameAndPwd = BasicAuthUtils.base64DecodeToStr(authorization.substring(6));
        String[] upArr = nameAndPwd.split(":");
        if (upArr.length != 2) {
            return false;
        }
        String iptName = upArr[0];
        String iptPwd = upArr[1];
        return iptPwd.equals(docket.basicAuth().get(iptName));
    }

    public static void response401(Context ctx) throws IOException {
        ctx.status(401);
        ctx.headerSet("WWW-Authenticate", "Basic realm=\"\u8bf7\u8f93\u5165Swagger\u6587\u6863\u8bbf\u95ee\u8d26\u53f7\u5bc6\u7801\"");
        ctx.output("\u65e0\u6743\u9650\u8bbf\u95ee");
    }
}

