/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.openapi2;

import io.swagger.annotations.ApiImplicitParam;
import java.util.Collection;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Cookie;
import org.noear.solon.annotation.Header;
import org.noear.solon.annotation.Path;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.wrap.ParamWrap;

public class ParamHolder {
    private ParamWrap param;
    private ApiImplicitParam anno;

    public ParamHolder(ParamWrap param) {
        this.param = param;
    }

    public ParamHolder binding(ApiImplicitParam anno) {
        this.anno = anno;
        return this;
    }

    public String toString() {
        return this.getName();
    }

    public ParamWrap getParam() {
        return this.param;
    }

    public ApiImplicitParam getAnno() {
        return this.anno;
    }

    public String getName() {
        if (this.param != null) {
            return this.param.getName();
        }
        if (this.anno != null) {
            return this.anno.name();
        }
        return null;
    }

    public String getDescription() {
        if (this.anno != null) {
            return this.anno.value();
        }
        return null;
    }

    public String dataType() {
        if (this.param != null) {
            if (UploadedFile.class.equals((Object)this.param.getType())) {
                return "file";
            }
            return this.param.getType().getSimpleName();
        }
        String tmp = null;
        if (this.anno != null) {
            tmp = this.anno.dataType();
        }
        if (Utils.isBlank(tmp)) {
            return "String";
        }
        return tmp;
    }

    public String paramType() {
        if (this.param != null && this.param.requireBody()) {
            return "body";
        }
        String tmp = null;
        if (this.anno != null) {
            tmp = this.anno.paramType();
        }
        if (Utils.isBlank(tmp)) {
            return "query";
        }
        return tmp;
    }

    public boolean allowMultiple() {
        if (this.param != null) {
            return this.param.getType().isArray() || Collection.class.isAssignableFrom(this.param.getType());
        }
        if (this.anno != null) {
            return this.anno.allowMultiple();
        }
        return false;
    }

    public boolean isRequired() {
        if (this.param != null && this.param.required()) {
            return true;
        }
        if (this.anno != null) {
            return this.anno.required();
        }
        return false;
    }

    public boolean isRequiredBody() {
        return this.param != null && this.param.requireBody();
    }

    public boolean isRequiredHeader() {
        return this.param != null && this.param.getParameter().isAnnotationPresent(Header.class);
    }

    public boolean isRequiredCookie() {
        return this.param != null && this.param.getParameter().isAnnotationPresent(Cookie.class);
    }

    public boolean isRequiredPath() {
        return this.param != null && this.param.getParameter().isAnnotationPresent(Path.class);
    }

    public boolean isReadOnly() {
        if (this.anno != null) {
            return this.anno.readOnly();
        }
        return false;
    }

    public boolean isIgnore() {
        if (this.param != null) {
            if (Context.class.equals((Object)this.param.getType())) {
                return true;
            }
            if (SessionState.class.equals((Object)this.param.getType())) {
                return true;
            }
        }
        return false;
    }
}

