/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.openapi2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.models.ArrayModel;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.UntypedProperty;
import io.swagger.models.refs.RefFormat;
import io.swagger.solon.annotation.ApiNoAuthorize;
import io.swagger.solon.annotation.ApiRes;
import io.swagger.solon.annotation.ApiResProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Get;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Endpoint;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.openapi2.ActionHolder;

public class Swagger2Builder {
    private final DocDocket docket;
    private ModelImpl globalResultModel;
    Swagger swagger = new Swagger();

    public Swagger2Builder(DocDocket docket) {
        this.docket = docket;
    }

    public Swagger build() {
        if (this.docket.globalResult() != null) {
            this.globalResultModel = (ModelImpl)this.parseSwaggerModel(this.docket.globalResult(), this.docket.globalResult());
        }
        this.parseGroupPackage();
        this.swagger.setSwagger(this.docket.version());
        this.swagger.info(new Info().title(this.docket.info().title()).description(this.docket.info().description()).termsOfService(this.docket.info().termsOfService()).version(this.docket.info().version()).license(this.docket.info().license()).contact(this.docket.info().contact()));
        this.swagger.host(this.getHost(this.docket));
        this.swagger.basePath(this.docket.basePath());
        this.swagger.schemes(this.docket.schemes());
        this.swagger.externalDocs(this.docket.externalDocs());
        this.swagger.vendorExtensions(this.docket.vendorExtensions());
        this.swagger.getTags().sort((t1, t2) -> {
            String name1 = t1.getDescription();
            String name2 = t2.getDescription();
            return Collator.getInstance(Locale.UK).compare(name1, name2);
        });
        ArrayList definitionKeys = new ArrayList(this.swagger.getDefinitions().keySet());
        LinkedHashMap definitionMap = new LinkedHashMap();
        definitionKeys.sort((name1, name2) -> Collator.getInstance(Locale.UK).compare((String)name1, (String)name2));
        for (String name : definitionKeys) {
            definitionMap.put(name, this.swagger.getDefinitions().get(name));
        }
        this.swagger.setDefinitions(definitionMap);
        this.swagger.setSecurityDefinitions(this.docket.securityDefinitions());
        return this.swagger;
    }

    private void parseGroupPackage() {
        Map<Class<?>, List<ActionHolder>> classMap = this.getApiAction();
        classMap.keySet().forEach(clazz -> {
            List actionHolders = (List)classMap.get(clazz);
            this.parseController((Class<?>)clazz, actionHolders);
        });
    }

    private Map<Class<?>, List<ActionHolder>> getApiAction() {
        HashMap apiMap = new HashMap(16);
        Collection routingCollection = Solon.app().router().getAll(Endpoint.main);
        for (Routing routing : routingCollection) {
            ArrayList<ActionHolder> actionHolders;
            if (!(routing.target() instanceof Action)) continue;
            Action action = (Action)routing.target();
            Class controller = action.controller().clz();
            boolean matched = this.docket.apis().stream().anyMatch(res -> res.test(action));
            if (!matched) continue;
            ActionHolder actionHolder = new ActionHolder((Routing<Handler>)routing, action);
            if (apiMap.containsKey(controller)) {
                if (!action.method().isAnnotationPresent(ApiOperation.class) || (actionHolders = (ArrayList<ActionHolder>)apiMap.get(controller)).contains(actionHolder)) continue;
                actionHolders.add(actionHolder);
                apiMap.put(controller, actionHolders);
                continue;
            }
            if (!controller.isAnnotationPresent(Api.class) || !action.method().isAnnotationPresent(ApiOperation.class)) continue;
            actionHolders = new ArrayList<ActionHolder>();
            actionHolders.add(actionHolder);
            apiMap.put(controller, actionHolders);
        }
        ArrayList ctlList = new ArrayList(apiMap.keySet());
        ctlList.sort(Comparator.comparingInt(clazz -> clazz.getAnnotation(Api.class).position()));
        LinkedHashMap result = new LinkedHashMap();
        ctlList.forEach(i -> {
            List actionHolders = (List)apiMap.get(i);
            actionHolders.sort(Comparator.comparingInt(ah -> ah.getAnnotation(ApiOperation.class).position()));
            result.put((Class<?>)i, actionHolders);
        });
        return result;
    }

    private void parseController(Class<?> clazz, List<ActionHolder> actionHolders) {
        Api api = clazz.getAnnotation(Api.class);
        boolean hidden = api.hidden();
        if (hidden) {
            return;
        }
        String controllerKey = this.getControllerKey(clazz);
        for (String tags : api.tags()) {
            Tag tag = new Tag();
            tag.setName(tags);
            tag.setDescription(controllerKey + " (" + clazz.getSimpleName() + ")");
            this.swagger.addTag(tag);
        }
        this.parseAction(actionHolders);
    }

    private void parseAction(List<ActionHolder> actionHolders) {
        for (ActionHolder actionHolder : actionHolders) {
            ApiOperation apiAction = actionHolder.getAnnotation(ApiOperation.class);
            if (apiAction.hidden()) {
                return;
            }
            String controllerKey = this.getControllerKey(actionHolder.controllerClz());
            String actionName = actionHolder.action().name();
            Method actionMethod = actionHolder.action().method().getMethod();
            HashSet<String> actionTags = new HashSet<String>();
            actionTags.addAll(Arrays.asList(actionHolder.controllerClz().getAnnotation(Api.class).tags()));
            actionTags.addAll(Arrays.asList(apiAction.tags()));
            actionTags.remove("");
            Path path = new Path();
            String pathKey = PathUtil.mergePath((String)controllerKey, (String)actionName);
            Operation operation = new Operation();
            operation.setTags(new ArrayList(actionTags));
            operation.setSummary(apiAction.value());
            operation.setDescription(apiAction.notes());
            operation.setDeprecated(Boolean.valueOf(actionHolder.isAnnotationPresent(Deprecated.class)));
            if (!(actionHolder.isAnnotationPresent(ApiNoAuthorize.class) || actionHolder.controllerClz().isAnnotationPresent(ApiNoAuthorize.class))) {
                for (String securityName : this.docket.securityDefinitions().keySet()) {
                    operation.security(new SecurityRequirement(securityName).scope("global"));
                }
            }
            String operationMethod = this.getHttpMethod(actionHolder, apiAction);
            operation.setParameters(this.parseActionParameters(actionMethod));
            operation.setResponses(this.parseActionResponse(controllerKey, actionName, actionMethod));
            operation.setVendorExtension("controllerKey", (Object)controllerKey);
            operation.setVendorExtension("actionName", (Object)actionName);
            if (Utils.isBlank((String)apiAction.consumes())) {
                if (operationMethod.equals("get")) {
                    operation.consumes("");
                } else {
                    operation.consumes("application/x-www-form-urlencoded");
                }
            } else {
                operation.consumes(apiAction.consumes());
            }
            operation.produces(Utils.isBlank((String)apiAction.produces()) ? "*/*" : apiAction.produces());
            operation.setOperationId(operationMethod + "_" + pathKey.replace("/", "_"));
            path.set(operationMethod, operation);
            this.swagger.path(pathKey, path);
        }
    }

    private List<Parameter> parseActionParameters(Method method) {
        ArrayList<ApiImplicitParam> apiParams = new ArrayList<ApiImplicitParam>();
        if (method.isAnnotationPresent(ApiImplicitParams.class)) {
            apiParams.addAll(Arrays.asList(method.getAnnotation(ApiImplicitParams.class).value()));
        }
        if (method.isAnnotationPresent(ApiImplicitParams.class)) {
            ApiImplicitParam[] paramArray = (ApiImplicitParam[])method.getAnnotationsByType(ApiImplicitParam.class);
            apiParams.addAll(Arrays.asList(paramArray));
        }
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        for (ApiImplicitParam apiParam : apiParams) {
            FormParameter formParameter;
            BodyParameter parameter;
            BodyParameter modelParameter;
            String dataType;
            String paramSchema = this.toParameterSchema(apiParam);
            String string = dataType = Utils.isBlank((String)apiParam.dataType()) ? "String" : apiParam.dataType();
            if (apiParam.allowMultiple() && Utils.isNotEmpty((String)paramSchema)) {
                modelParameter = new BodyParameter();
                modelParameter.setSchema((Model)new ArrayModel().items((Property)new RefProperty(paramSchema)));
                parameter = modelParameter;
            } else if (apiParam.allowMultiple() && "file".equals(dataType)) {
                formParameter = new FormParameter();
                formParameter.type("array");
                formParameter.items((Property)new FileProperty());
                formParameter.collectionFormat("multi");
                parameter = formParameter;
            } else if (Utils.isNotEmpty((String)paramSchema)) {
                modelParameter = new BodyParameter();
                modelParameter.setSchema((Model)new RefModel(paramSchema));
                parameter = modelParameter;
            } else if (method.getAnnotation(Get.class) != null) {
                formParameter = new QueryParameter();
                formParameter.setFormat(apiParam.format());
                formParameter.setType(dataType);
                formParameter.setDefaultValue(apiParam.defaultValue());
                parameter = formParameter;
            } else {
                formParameter = new FormParameter();
                formParameter.setFormat(apiParam.format());
                formParameter.setType(dataType);
                formParameter.setDefaultValue(apiParam.defaultValue());
                parameter = formParameter;
            }
            parameter.setName(apiParam.name());
            parameter.setDescription(apiParam.value());
            parameter.setRequired(apiParam.required());
            parameter.setReadOnly(parameter.isReadOnly());
            parameter.setIn(Utils.isBlank((String)apiParam.paramType()) ? "query" : apiParam.paramType());
            paramList.add((Parameter)parameter);
        }
        return paramList;
    }

    private Map<String, Response> parseActionResponse(String controllerKey, String actionName, Method method) {
        LinkedHashMap<String, Response> responseMap = new LinkedHashMap<String, Response>();
        this.docket.globalResponseCodes().forEach((key, value) -> {
            String schema;
            Response response = new Response();
            response.description(value);
            if (key == 200 && (schema = this.parseResponse(controllerKey, actionName, method)) != null) {
                response.setResponseSchema((Model)new RefModel(schema));
            }
            responseMap.put(String.valueOf(key), response);
        });
        return responseMap;
    }

    private String parseResponse(String controllerKey, String actionName, Method method) {
        Class<?> apiResClz;
        String swaggerModelName = null;
        ArrayList<ApiResProperty> responses = new ArrayList<ApiResProperty>();
        if (method.isAnnotationPresent(ApiRes.class)) {
            responses.addAll(Arrays.asList(method.getAnnotation(ApiRes.class).value()));
        }
        if (method.isAnnotationPresent(ApiRes.class)) {
            ApiResProperty[] paramArray = (ApiResProperty[])method.getAnnotationsByType(ApiResProperty.class);
            responses.addAll(Arrays.asList(paramArray));
        }
        if ((apiResClz = method.getReturnType()) != Void.class && apiResClz.isAnnotationPresent(ApiModel.class)) {
            ModelImpl commonResKv = (ModelImpl)this.parseSwaggerModel(apiResClz, method.getGenericReturnType());
            swaggerModelName = commonResKv.getName();
            return swaggerModelName;
        }
        if (responses.size() == 0) {
            if (this.globalResultModel != null) {
                swaggerModelName = this.globalResultModel.getName();
            }
        } else {
            ModelImpl swaggerModelKv = (ModelImpl)this.parseSwaggerModel(controllerKey, actionName, responses);
            swaggerModelName = swaggerModelKv.getName();
            if (this.docket.globalResponseInData()) {
                swaggerModelName = this.toResponseInData(swaggerModelName);
            }
        }
        return swaggerModelName;
    }

    private String toResponseInData(String swaggerModelName) {
        if (this.globalResultModel != null) {
            LinkedHashMap<String, RefProperty> propertyMap = new LinkedHashMap<String, RefProperty>();
            propertyMap.putAll(this.globalResultModel.getProperties());
            RefProperty property = new RefProperty(swaggerModelName, RefFormat.INTERNAL);
            property.setDescription("\u8fd4\u56de\u503c");
            propertyMap.put("data", property);
            swaggerModelName = this.globalResultModel.getName() + "\u00ab" + swaggerModelName + "\u00bb";
            ModelImpl model = new ModelImpl();
            model.setTitle(swaggerModelName);
            model.setProperties(propertyMap);
            this.swagger.addDefinition(swaggerModelName, (Model)model);
        }
        return swaggerModelName;
    }

    private Model parseSwaggerModel(Class<?> clazz, Type type) {
        Field[] fields;
        Model model;
        Map typeMap;
        String modelName = clazz.getSimpleName();
        if (type instanceof ParameterizedType && (typeMap = GenericUtil.getGenericInfo((Type)type)).size() > 0) {
            StringBuilder buf = new StringBuilder();
            typeMap.forEach((k, v) -> {
                if (v instanceof Class) {
                    buf.append(((Class)v).getSimpleName()).append(",");
                }
            });
            buf.setLength(buf.length() - 1);
            modelName = modelName + "\u00ab" + buf + "\u00bb";
        }
        if (this.swagger.getDefinitions() != null && null != (model = (Model)this.swagger.getDefinitions().get(modelName))) {
            return model;
        }
        ApiModel apiModel = clazz.getAnnotation(ApiModel.class);
        String title = apiModel != null ? apiModel.description() : modelName;
        LinkedHashMap<String, Object> fieldList = new LinkedHashMap<String, Object>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Map genericMap;
            Type typeClazz2;
            if (Modifier.isStatic(field.getModifiers())) continue;
            ApiModelProperty apiField = field.getAnnotation(ApiModelProperty.class);
            if (field.getType() == List.class) {
                Type genericType = field.getGenericType();
                if (genericType == null || !(genericType instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)genericType;
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel(genericClazz, genericClazz);
                ObjectProperty fieldKv = new ObjectProperty();
                fieldKv.setName(swaggerModel.getName());
                if (apiField != null) {
                    fieldKv.setDescription(apiField.value());
                }
                fieldKv.setType("object");
                fieldList.put(field.getName(), fieldKv);
                continue;
            }
            Class typeClazz = field.getType();
            Type typeGenericType = field.getGenericType();
            if (typeGenericType instanceof TypeVariable && type instanceof ParameterizedType && (typeClazz2 = (Type)(genericMap = GenericUtil.getGenericInfo((Type)type)).get(typeGenericType.getTypeName())) instanceof Class) {
                typeClazz = (Class)typeClazz2;
            }
            if (typeClazz.isAnnotationPresent(ApiModel.class)) {
                ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel(typeClazz, typeClazz);
                RefProperty fieldKv = new RefProperty(swaggerModel.getName(), RefFormat.INTERNAL);
                if (apiField != null) {
                    fieldKv.setDescription(apiField.value());
                }
                fieldList.put(field.getName(), fieldKv);
                continue;
            }
            ObjectProperty fieldKv = new ObjectProperty();
            fieldKv.setName(field.getName());
            if (apiField != null) {
                fieldKv.setDescription(apiField.value());
                fieldKv.setType(Utils.isBlank((String)apiField.dataType()) ? field.getType().getSimpleName().toLowerCase() : apiField.dataType());
                fieldKv.setExample(apiField.example());
            } else {
                fieldKv.setType(field.getType().getSimpleName().toLowerCase());
            }
            fieldList.put(field.getName(), fieldKv);
        }
        ModelImpl model2 = new ModelImpl();
        model2.setProperties(fieldList);
        model2.setName(modelName);
        model2.setTitle(title);
        model2.setType("object");
        this.swagger.addDefinition(modelName, (Model)model2);
        return model2;
    }

    private Model parseSwaggerModel(String controllerKey, String actionName, List<ApiResProperty> responses) {
        String modelName = controllerKey + "_" + actionName;
        LinkedHashMap<String, ArrayProperty> propertiesList = new LinkedHashMap<String, ArrayProperty>();
        if (!this.docket.globalResponseInData() && this.globalResultModel != null) {
            propertiesList.putAll(this.globalResultModel.getProperties());
        }
        for (ApiResProperty apiResponse : responses) {
            ArrayProperty fieldKv;
            if (apiResponse.dataTypeClass() != Void.class) {
                ArrayProperty fieldKv2;
                ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel(apiResponse.dataTypeClass(), apiResponse.dataTypeClass());
                if (apiResponse.allowMultiple()) {
                    fieldKv2 = new ArrayProperty();
                    fieldKv2.setName(swaggerModel.getName());
                    fieldKv2.setDescription(apiResponse.value());
                    fieldKv2.items((Property)new RefProperty(swaggerModel.getName()));
                    propertiesList.put(apiResponse.name(), fieldKv2);
                    continue;
                }
                fieldKv2 = new ObjectProperty();
                fieldKv2.setName(swaggerModel.getName());
                fieldKv2.setDescription(apiResponse.value());
                propertiesList.put(apiResponse.name(), fieldKv2);
                continue;
            }
            if (apiResponse.allowMultiple()) {
                fieldKv = new ArrayProperty();
                fieldKv.setName(apiResponse.name());
                fieldKv.setDescription(apiResponse.value());
                fieldKv.setFormat(Utils.isBlank((String)apiResponse.format()) ? "" : apiResponse.format());
                fieldKv.setExample(apiResponse.example());
                UntypedProperty itemsProperty = new UntypedProperty();
                itemsProperty.setType(Utils.isBlank((String)apiResponse.dataType()) ? "string" : apiResponse.dataType());
                fieldKv.items((Property)itemsProperty);
                propertiesList.put(apiResponse.name(), fieldKv);
                continue;
            }
            fieldKv = new UntypedProperty();
            fieldKv.setName(apiResponse.name());
            fieldKv.setDescription(apiResponse.value());
            fieldKv.setType(Utils.isBlank((String)apiResponse.dataType()) ? "string" : apiResponse.dataType());
            fieldKv.setFormat(Utils.isBlank((String)apiResponse.format()) ? "" : apiResponse.format());
            fieldKv.setExample(apiResponse.example());
            propertiesList.put(apiResponse.name(), fieldKv);
        }
        ModelImpl model = new ModelImpl();
        model.setProperties(propertiesList);
        model.setName(modelName);
        this.swagger.addDefinition(modelName, (Model)model);
        return model;
    }

    private String toParameterSchema(ApiImplicitParam apiParam) {
        if (apiParam.dataTypeClass() != Void.class) {
            ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel(apiParam.dataTypeClass(), apiParam.dataTypeClass());
            return swaggerModel.getName();
        }
        return null;
    }

    public String getHttpMethod(ActionHolder actionHolder, ApiOperation apiAction) {
        if (Utils.isBlank((String)apiAction.httpMethod())) {
            MethodType methodType = actionHolder.routing().method();
            if (methodType == null) {
                return "get";
            }
            if (methodType.ordinal() < MethodType.UNKNOWN.ordinal()) {
                return methodType.name.toLowerCase();
            }
            return "get";
        }
        return apiAction.httpMethod();
    }

    private String getHost(DocDocket swaggerDock) {
        String host = swaggerDock.host();
        if (Utils.isBlank((String)host)) {
            host = "localhost";
            if (Solon.cfg().serverPort() != 80) {
                host = host + ":" + Solon.cfg().serverPort();
            }
        }
        return host;
    }

    private String getControllerKey(Class<?> controllerClz) {
        Mapping mapping = controllerClz.getAnnotation(Mapping.class);
        if (mapping == null) {
            return "";
        }
        String path = Utils.annoAlias((String)mapping.value(), (String)mapping.path());
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }
}

