/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.openapi2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.noear.solon.core.serialize.Serializer;

public class JacksonSerializer
implements Serializer<String> {
    private static final JacksonSerializer instance = new JacksonSerializer();
    private ObjectMapper mapper = new ObjectMapper();

    public static JacksonSerializer getInstance() {
        return instance;
    }

    public JacksonSerializer() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public String name() {
        return "JacksonSerializer";
    }

    public String serialize(Object fromObj) throws IOException {
        return this.mapper.writeValueAsString(fromObj);
    }

    public Object deserialize(String data, Class<?> toClz) throws IOException {
        if (toClz == null) {
            return this.mapper.readTree(data);
        }
        return this.mapper.readValue(data, toClz);
    }
}

