/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.noear.solon.cloud.impl.CloudLoadBalance;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.core.LoadBalance;

public class CloudLoadBalanceFactory
implements LoadBalance.Factory {
    private final Map<String, CloudLoadBalance> cached = new ConcurrentHashMap<String, CloudLoadBalance>();

    public CloudLoadBalance get(String service) {
        return this.get("", service);
    }

    public CloudLoadBalance get(String group, String service) {
        if (group == null) {
            group = "";
        }
        String cacheKey = group + ":" + service;
        return this.cached.get(cacheKey);
    }

    public int count() {
        return this.cached.size();
    }

    public void forEach(BiConsumer<String, CloudLoadBalance> action) {
        this.cached.forEach(action);
    }

    public LoadBalance create(String service) {
        return this.create("", service);
    }

    public LoadBalance create(String group, String service) {
        if (group == null) {
            group = "";
        }
        String cacheKey = group + ":" + service;
        String group2 = group;
        return this.cached.computeIfAbsent(cacheKey, k -> new CloudLoadBalance(group2, service));
    }

    public void register(String group, String service, Discovery discovery) {
        if (group == null) {
            group = "";
        }
        String cacheKey = group + ":" + service;
        String group2 = group;
        this.cached.computeIfAbsent(cacheKey, k -> new CloudLoadBalance(group2, service, discovery));
    }
}

