/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.Properties;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Props;

public class CloudProps {
    public static final String PREFIX_config = "config.";
    public static final String PREFIX_discovery = "discovery.";
    public static final String PREFIX_event = "event.";
    public static final String PREFIX_lock = "lock.";
    public static final String PREFIX_log = "log.";
    public static final String PREFIX_trace = "trace.";
    public static final String PREFIX_metric = "metric.";
    public static final String PREFIX_file = "file.";
    public static final String PREFIX_i18n = "i18n.";
    public static final String PREFIX_id = "id.";
    public static final String PREFIX_list = "list.";
    public static final String PREFIX_job = "job.";
    public static String LOG_DEFAULT_LOGGER;
    private String ROOT = "solon.cloud.@@.";
    private String SERVER = "solon.cloud.@@.server";
    private String TOKEN = "solon.cloud.@@.token";
    private String ALARM = "solon.cloud.@@.alarm";
    private String USERNAME = "solon.cloud.@@.username";
    private String PASSWORD = "solon.cloud.@@.password";
    private String ACCESS_KEY = "solon.cloud.@@.accessKey";
    private String SECRET_KEY = "solon.cloud.@@.secretKey";
    private String CONFIG_ENABLE = "solon.cloud.@@.config.enable";
    private String CONFIG_SERVER = "solon.cloud.@@.config.server";
    private String CONFIG_LOAD = "solon.cloud.@@.config.load";
    private String CONFIG_REFRESH_INTERVAL = "solon.cloud.@@.config.refreshInterval";
    private String DISCOVERY_ENABLE = "solon.cloud.@@.discovery.enable";
    private String DISCOVERY_SERVER = "solon.cloud.@@.discovery.server";
    private String DISCOVERY_CLUSTER_NAME = "solon.cloud.@@.discovery.clusterName";
    private String DISCOVERY_HEALTH_CHECK_INTERVAL = "solon.cloud.@@.discovery.healthCheckInterval";
    private String DISCOVERY_REFRESH_INTERVAL = "solon.cloud.@@.discovery.refreshInterval";
    private String EVENT_ENABLE = "solon.cloud.@@.event.enable";
    private String EVENT_SERVER = "solon.cloud.@@.event.server";
    private String EVENT_PREFETCH_COUNT = "solon.cloud.@@.event.prefetchCount";
    private String EVENT_PUBLISH_TIMEOUT = "solon.cloud.@@.event.publishTimeout";
    private String EVENT_CHANNEL = "solon.cloud.@@.event.channel";
    private String EVENT_BROKER = "solon.cloud.@@.event.broker";
    private String EVENT_GROUP = "solon.cloud.@@.event.group";
    private String EVENT_CONSUMER = "solon.cloud.@@.event.consumer";
    private String EVENT_PRODUCER = "solon.cloud.@@.event.producer";
    private String EVENT_CLIENT = "solon.cloud.@@.event.client";
    private String EVENT_USERNAME = "solon.cloud.@@.event.username";
    private String EVENT_PASSWORD = "solon.cloud.@@.event.password";
    private String EVENT_ACCESS_KEY = "solon.cloud.@@.event.accessKey";
    private String EVENT_SECRET_KEY = "solon.cloud.@@.event.secretKey";
    private String LOCK_ENABLE = "solon.cloud.@@.lock.enable";
    private String LOCK_SERVER = "solon.cloud.@@.lock.server";
    private String LOG_ENABLE = "solon.cloud.@@.log.enable";
    private String LOG_SERVER = "solon.cloud.@@.log.server";
    private String LOG_DEFAULT = "solon.cloud.@@.log.default";
    private String TRACE_ENABLE = "solon.cloud.@@.trace.enable";
    private String TRACE_EXCLUDE = "solon.cloud.@@.trace.exclude";
    private String METRIC_ENABLE = "solon.cloud.@@.metric.enable";
    private String FILE_ENABLE = "solon.cloud.@@.file.enable";
    private String FILE_BUCKET = "solon.cloud.@@.file.bucket";
    private String FILE_ENDPOINT = "solon.cloud.@@.file.endpoint";
    private String FILE_REGION_ID = "solon.cloud.@@.file.regionId";
    private String FILE_USERNAME = "solon.cloud.@@.file.username";
    private String FILE_PASSWORD = "solon.cloud.@@.file.password";
    private String FILE_ACCESS_KEY = "solon.cloud.@@.file.accessKey";
    private String FILE_SECRET_KEY = "solon.cloud.@@.file.secretKey";
    private String I18N_ENABLE = "solon.cloud.@@.i18n.enable";
    private String I18N_DEFAULT = "solon.cloud.@@.i18n.default";
    private String ID_ENABLE = "solon.cloud.@@.id.enable";
    private String ID_START = "solon.cloud.@@.id.start";
    private String LIST_ENABLE = "solon.cloud.@@.list.enable";
    private String JOB_ENABLE = "solon.cloud.@@.job.enable";
    private String JOB_SERVER = "solon.cloud.@@.job.server";
    private final AopContext aopContext;
    private String username;
    private String password;
    private String eventServer;
    private String eventUsername;
    private String eventPassword;
    private String fileUsername;
    private String filePassword;

    public CloudProps(AopContext aopContext, String frame) {
        this.aopContext = aopContext;
        this.ROOT = this.ROOT.replace("@@", frame);
        this.SERVER = this.SERVER.replace("@@", frame);
        this.TOKEN = this.TOKEN.replace("@@", frame);
        this.ALARM = this.ALARM.replace("@@", frame);
        this.USERNAME = this.USERNAME.replace("@@", frame);
        this.PASSWORD = this.PASSWORD.replace("@@", frame);
        this.ACCESS_KEY = this.ACCESS_KEY.replace("@@", frame);
        this.SECRET_KEY = this.SECRET_KEY.replace("@@", frame);
        this.CONFIG_ENABLE = this.CONFIG_ENABLE.replace("@@", frame);
        this.CONFIG_SERVER = this.CONFIG_SERVER.replace("@@", frame);
        this.CONFIG_LOAD = this.CONFIG_LOAD.replace("@@", frame);
        this.CONFIG_REFRESH_INTERVAL = this.CONFIG_REFRESH_INTERVAL.replace("@@", frame);
        this.DISCOVERY_ENABLE = this.DISCOVERY_ENABLE.replace("@@", frame);
        this.DISCOVERY_SERVER = this.DISCOVERY_SERVER.replace("@@", frame);
        this.DISCOVERY_CLUSTER_NAME = this.DISCOVERY_CLUSTER_NAME.replace("@@", frame);
        this.DISCOVERY_HEALTH_CHECK_INTERVAL = this.DISCOVERY_HEALTH_CHECK_INTERVAL.replace("@@", frame);
        this.DISCOVERY_REFRESH_INTERVAL = this.DISCOVERY_REFRESH_INTERVAL.replace("@@", frame);
        this.EVENT_ENABLE = this.EVENT_ENABLE.replace("@@", frame);
        this.EVENT_SERVER = this.EVENT_SERVER.replace("@@", frame);
        this.EVENT_PREFETCH_COUNT = this.EVENT_PREFETCH_COUNT.replace("@@", frame);
        this.EVENT_PUBLISH_TIMEOUT = this.EVENT_PUBLISH_TIMEOUT.replace("@@", frame);
        this.EVENT_CHANNEL = this.EVENT_CHANNEL.replace("@@", frame);
        this.EVENT_BROKER = this.EVENT_BROKER.replace("@@", frame);
        this.EVENT_GROUP = this.EVENT_GROUP.replace("@@", frame);
        this.EVENT_CONSUMER = this.EVENT_CONSUMER.replace("@@", frame);
        this.EVENT_PRODUCER = this.EVENT_PRODUCER.replace("@@", frame);
        this.EVENT_CLIENT = this.EVENT_CLIENT.replace("@@", frame);
        this.EVENT_USERNAME = this.EVENT_USERNAME.replace("@@", frame);
        this.EVENT_PASSWORD = this.EVENT_PASSWORD.replace("@@", frame);
        this.EVENT_ACCESS_KEY = this.EVENT_ACCESS_KEY.replace("@@", frame);
        this.EVENT_SECRET_KEY = this.EVENT_SECRET_KEY.replace("@@", frame);
        this.LOCK_ENABLE = this.LOCK_ENABLE.replace("@@", frame);
        this.LOCK_SERVER = this.LOCK_SERVER.replace("@@", frame);
        this.LOG_ENABLE = this.LOG_ENABLE.replace("@@", frame);
        this.LOG_SERVER = this.LOG_SERVER.replace("@@", frame);
        this.LOG_DEFAULT = this.LOG_DEFAULT.replace("@@", frame);
        this.TRACE_ENABLE = this.TRACE_ENABLE.replace("@@", frame);
        this.TRACE_EXCLUDE = this.TRACE_EXCLUDE.replace("@@", frame);
        this.METRIC_ENABLE = this.METRIC_ENABLE.replace("@@", frame);
        this.FILE_ENABLE = this.FILE_ENABLE.replace("@@", frame);
        this.FILE_ENDPOINT = this.FILE_ENDPOINT.replace("@@", frame);
        this.FILE_REGION_ID = this.FILE_REGION_ID.replace("@@", frame);
        this.FILE_BUCKET = this.FILE_BUCKET.replace("@@", frame);
        this.FILE_USERNAME = this.FILE_USERNAME.replace("@@", frame);
        this.FILE_PASSWORD = this.FILE_PASSWORD.replace("@@", frame);
        this.FILE_ACCESS_KEY = this.FILE_ACCESS_KEY.replace("@@", frame);
        this.FILE_SECRET_KEY = this.FILE_SECRET_KEY.replace("@@", frame);
        this.I18N_ENABLE = this.I18N_ENABLE.replace("@@", frame);
        this.I18N_DEFAULT = this.I18N_DEFAULT.replace("@@", frame);
        this.ID_ENABLE = this.ID_ENABLE.replace("@@", frame);
        this.ID_START = this.ID_START.replace("@@", frame);
        this.LIST_ENABLE = this.LIST_ENABLE.replace("@@", frame);
        this.JOB_ENABLE = this.JOB_ENABLE.replace("@@", frame);
        this.JOB_SERVER = this.JOB_SERVER.replace("@@", frame);
    }

    public String getServer() {
        return this.aopContext.cfg().get(this.SERVER);
    }

    public String getToken() {
        return this.aopContext.cfg().get(this.TOKEN);
    }

    public String getAlarm() {
        return this.aopContext.cfg().get(this.ALARM);
    }

    public String getUsername() {
        if (this.username == null) {
            this.username = this.aopContext.cfg().get(this.USERNAME);
            if (this.username == null) {
                this.username = this.aopContext.cfg().get(this.ACCESS_KEY);
            }
            if (this.username == null) {
                this.username = "";
            }
        }
        return this.username;
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = this.aopContext.cfg().get(this.PASSWORD);
            if (this.password == null) {
                this.password = this.aopContext.cfg().get(this.SECRET_KEY);
            }
            if (this.password == null) {
                this.password = "";
            }
        }
        return this.password;
    }

    public String getAccessKey() {
        return this.getUsername();
    }

    public String getSecretKey() {
        return this.getPassword();
    }

    public boolean getConfigEnable() {
        return this.aopContext.cfg().getBool(this.CONFIG_ENABLE, true);
    }

    public String getConfigServer() {
        String tmp = this.aopContext.cfg().get(this.CONFIG_SERVER);
        if (Utils.isEmpty((String)tmp)) {
            return this.getServer();
        }
        return tmp;
    }

    public String getConfigLoad() {
        return this.aopContext.cfg().get(this.CONFIG_LOAD);
    }

    public String getConfigRefreshInterval(String def) {
        return this.aopContext.cfg().get(this.CONFIG_REFRESH_INTERVAL, def);
    }

    public boolean getDiscoveryEnable() {
        return this.aopContext.cfg().getBool(this.DISCOVERY_ENABLE, true);
    }

    public String getDiscoveryServer() {
        String tmp = this.aopContext.cfg().get(this.DISCOVERY_SERVER);
        if (Utils.isEmpty((String)tmp)) {
            return this.getServer();
        }
        return tmp;
    }

    @Deprecated
    public String getDiscoveryTags() {
        return "";
    }

    public String getDiscoveryClusterName() {
        return this.aopContext.cfg().get(this.DISCOVERY_CLUSTER_NAME);
    }

    public String getDiscoveryHealthCheckInterval(String def) {
        return this.aopContext.cfg().get(this.DISCOVERY_HEALTH_CHECK_INTERVAL, def);
    }

    public String getDiscoveryRefreshInterval(String def) {
        return this.aopContext.cfg().get(this.DISCOVERY_REFRESH_INTERVAL, def);
    }

    public boolean getEventEnable() {
        return this.aopContext.cfg().getBool(this.EVENT_ENABLE, true);
    }

    public String getEventServer() {
        if (this.eventServer == null) {
            this.eventServer = this.aopContext.cfg().get(this.EVENT_SERVER);
            if (this.eventServer == null) {
                this.eventServer = this.getServer();
            }
        }
        return this.eventServer;
    }

    public int getEventPrefetchCount() {
        return this.aopContext.cfg().getInt(this.EVENT_PREFETCH_COUNT, 0);
    }

    public long getEventPublishTimeout() {
        return this.getEventPublishTimeout(3000L);
    }

    public long getEventPublishTimeout(long def) {
        return this.aopContext.cfg().getLong(this.EVENT_PUBLISH_TIMEOUT, def);
    }

    public String getEventChannel() {
        return this.aopContext.cfg().get(this.EVENT_CHANNEL, "");
    }

    public String getEventBroker() {
        return this.aopContext.cfg().get(this.EVENT_BROKER, "");
    }

    public String getEventGroup() {
        return this.aopContext.cfg().get(this.EVENT_GROUP, "");
    }

    public Properties getEventConsumerProps() {
        return this.aopContext.cfg().getProp(this.EVENT_CONSUMER);
    }

    public Properties getEventProducerProps() {
        return this.aopContext.cfg().getProp(this.EVENT_PRODUCER);
    }

    public Properties getEventClientProps() {
        return this.aopContext.cfg().getProp(this.EVENT_CLIENT);
    }

    public String getEventUsername() {
        if (this.eventUsername == null) {
            this.eventUsername = this.aopContext.cfg().get(this.EVENT_USERNAME);
            if (this.eventUsername == null) {
                this.eventUsername = this.aopContext.cfg().get(this.EVENT_ACCESS_KEY);
            }
            if (this.eventUsername == null) {
                this.eventUsername = this.getUsername();
            }
        }
        return this.eventUsername;
    }

    public String getEventPassword() {
        if (this.eventPassword == null) {
            this.eventPassword = this.aopContext.cfg().get(this.EVENT_PASSWORD);
            if (this.eventPassword == null) {
                this.eventPassword = this.aopContext.cfg().get(this.EVENT_SECRET_KEY);
            }
            if (this.eventPassword == null) {
                this.eventPassword = this.getPassword();
            }
        }
        return this.eventPassword;
    }

    public String getEventAccessKey() {
        return this.getEventUsername();
    }

    public String getEventSecretKey() {
        return this.getEventPassword();
    }

    public boolean getLockEnable() {
        return this.aopContext.cfg().getBool(this.LOCK_ENABLE, true);
    }

    public String getLockServer() {
        String tmp = this.aopContext.cfg().get(this.LOCK_SERVER);
        if (Utils.isEmpty((String)tmp)) {
            return this.getServer();
        }
        return tmp;
    }

    public boolean getLogEnable() {
        return this.aopContext.cfg().getBool(this.LOG_ENABLE, true);
    }

    public String getLogServer() {
        String tmp = this.aopContext.cfg().get(this.LOG_SERVER);
        if (Utils.isEmpty((String)tmp)) {
            return this.getServer();
        }
        return tmp;
    }

    public String getLogDefault() {
        return this.aopContext.cfg().get(this.LOG_DEFAULT);
    }

    public boolean getTraceEnable() {
        return this.aopContext.cfg().getBool(this.TRACE_ENABLE, true);
    }

    public String getTraceExclude() {
        return this.aopContext.cfg().get(this.TRACE_EXCLUDE);
    }

    public boolean getMetricEnable() {
        return this.aopContext.cfg().getBool(this.METRIC_ENABLE, true);
    }

    public boolean getFileEnable() {
        return this.aopContext.cfg().getBool(this.FILE_ENABLE, true);
    }

    public String getFileEndpoint() {
        return this.aopContext.cfg().get(this.FILE_ENDPOINT);
    }

    public String getFileRegionId() {
        return this.aopContext.cfg().get(this.FILE_REGION_ID);
    }

    public String getFileBucket() {
        return this.aopContext.cfg().get(this.FILE_BUCKET);
    }

    public String getFileUsername() {
        if (this.fileUsername == null) {
            this.fileUsername = this.aopContext.cfg().get(this.FILE_USERNAME);
            if (this.fileUsername == null) {
                this.fileUsername = this.aopContext.cfg().get(this.FILE_ACCESS_KEY);
            }
            if (this.fileUsername == null) {
                this.fileUsername = this.getUsername();
            }
        }
        return this.fileUsername;
    }

    public String getFilePassword() {
        if (this.filePassword == null) {
            this.filePassword = this.aopContext.cfg().get(this.FILE_PASSWORD);
            if (this.filePassword == null) {
                this.filePassword = this.aopContext.cfg().get(this.FILE_SECRET_KEY);
            }
            if (this.filePassword == null) {
                this.filePassword = this.getPassword();
            }
        }
        return this.filePassword;
    }

    public String getFileAccessKey() {
        return this.getFileUsername();
    }

    public String getFileSecretKey() {
        return this.getFilePassword();
    }

    public boolean getI18nEnable() {
        return this.aopContext.cfg().getBool(this.I18N_ENABLE, true);
    }

    public String getI18nDefault() {
        return this.aopContext.cfg().get(this.I18N_DEFAULT);
    }

    public boolean getIdEnable() {
        return this.aopContext.cfg().getBool(this.ID_ENABLE, true);
    }

    public long getIdStart() {
        return this.aopContext.cfg().getLong(this.ID_START, 0L);
    }

    public boolean getListEnable() {
        return this.aopContext.cfg().getBool(this.LIST_ENABLE, true);
    }

    public boolean getJobEnable() {
        return this.aopContext.cfg().getBool(this.JOB_ENABLE, true);
    }

    public String getJobServer() {
        String tmp = this.aopContext.cfg().get(this.JOB_SERVER);
        if (Utils.isEmpty((String)tmp)) {
            return this.getServer();
        }
        return tmp;
    }

    public String getValue(String name) {
        return this.aopContext.cfg().get(this.ROOT + name);
    }

    public String getValue(String name, String def) {
        return this.aopContext.cfg().get(this.ROOT + name, def);
    }

    public void setValue(String name, String value) {
        this.aopContext.cfg().setProperty(this.ROOT + name, value);
    }

    public Props getProp() {
        return this.aopContext.cfg().getProp(this.ROOT.substring(0, this.ROOT.length() - 1));
    }

    public Props getProp(String keyStarts) {
        return this.aopContext.cfg().getProp(this.ROOT + keyStarts);
    }
}

