/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventService;

public class CloudEventManager
implements CloudEventService {
    Map<String, CloudEventService> route = new HashMap<String, CloudEventService>();

    public void register(String channel, CloudEventService service) {
        if (channel == null) {
            this.route.put("", service);
        } else {
            this.route.put(channel, service);
        }
    }

    public CloudEventService get(String channel) {
        if (channel == null) {
            channel = "";
        }
        return this.route.get(channel);
    }

    protected CloudEventService getOrThrow(String channel) {
        CloudEventService tmp = this.get(channel);
        if (tmp == null) {
            if (Utils.isEmpty((String)channel)) {
                throw new RuntimeException("CloudEventService does not exist");
            }
            throw new RuntimeException("CloudEventService does not exist channel &" + channel);
        }
        return tmp;
    }

    @Override
    public boolean publish(Event event) throws CloudEventException {
        return this.getOrThrow(event.channel()).publish(event);
    }

    @Override
    public void attention(EventLevel level, String channel, String group, String topic, CloudEventHandler observer) {
        this.getOrThrow(channel).attention(level, channel, group, topic, observer);
    }
}

