/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.cloud.model.BreakerEntry;
import org.noear.solon.cloud.model.BreakerException;
import org.noear.solon.cloud.service.CloudBreakerService;
import org.noear.solon.core.Props;

public abstract class CloudBreakerServiceLocalImpl
implements CloudBreakerService {
    Map<String, BreakerEntry> breakers = new HashMap<String, BreakerEntry>();

    public CloudBreakerServiceLocalImpl() {
        Props props = Solon.cfg().getProp("solon.cloud.local.breaker");
        if (props.size() > 0) {
            for (Object k : props.keySet()) {
                String key;
                int val;
                if (!(k instanceof String) || (val = props.getInt(key = (String)k, 0)) <= 0) continue;
                this.breakers.put(key, this.create(key, val));
            }
        }
    }

    protected abstract BreakerEntry create(String var1, int var2);

    @Override
    public AutoCloseable entry(String breakerName) throws BreakerException {
        BreakerEntry tmp = this.breakers.get(breakerName);
        if (tmp == null) {
            throw new IllegalArgumentException("Missing breaker configuration: " + breakerName);
        }
        return tmp.enter();
    }
}

