/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Note;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventService;
import org.noear.solon.cloud.service.CloudLogService;
import org.noear.solon.cloud.service.CloudTraceService;

public class CloudClient {
    @Note(value="\u914d\u7f6e\u670d\u52a1")
    public static CloudConfigService config() {
        return CloudManager.configService();
    }

    @Note(value="\u914d\u7f6e\u670d\u52a1\uff0c\u52a0\u8f7d\u9ed8\u8ba4\u914d\u7f6e")
    public static void configLoad(String group, String key) {
        if (CloudClient.config() == null) {
            return;
        }
        if (Utils.isNotEmpty((String)key)) {
            Config config = CloudClient.config().pull(group, key);
            if (config != null && Utils.isNotEmpty((String)config.value())) {
                Properties properties = config.toProps();
                Solon.cfg().loadAdd(properties);
            }
            CloudClient.config().attention(group, key, cfg -> {
                Properties properties = config.toProps();
                Solon.cfg().loadAdd(properties);
            });
        }
    }

    @Note(value="\u53d1\u73b0\u670d\u52a1")
    public static CloudDiscoveryService discovery() {
        return CloudManager.discoveryService();
    }

    @Note(value="\u53d1\u73b0\u670d\u52a1\uff0c\u63a8\u9001\u672c\u5730\u670d\u52a1\uff08\u5373\u6ce8\u518c\uff09")
    public static void discoveryPush() {
        if (CloudClient.discovery() == null) {
            return;
        }
        if (Utils.isNotEmpty((String)Solon.cfg().appName())) {
            Instance instance = Instance.localNew();
            CloudClient.discovery().register(Solon.cfg().appGroup(), instance);
        }
    }

    @Note(value="\u4e8b\u4ef6\u670d\u52a1")
    public static CloudEventService event() {
        return CloudManager.eventService();
    }

    @Note(value="\u65e5\u5fd7\u670d\u52a1")
    public static CloudLogService log() {
        return CloudManager.logService();
    }

    @Note(value="\u94fe\u8def\u8ddf\u8e2a\u670d\u52a1")
    public static CloudTraceService trace() {
        return CloudManager.traceService();
    }
}

