/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.annotation.CloudConfig;
import org.noear.solon.cloud.annotation.CloudEvent;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventService;
import org.noear.solon.cloud.service.CloudLogService;

public class CloudManager {
    private static CloudDiscoveryService discoveryService;
    private static CloudConfigService configService;
    private static CloudEventService eventService;
    private static CloudLogService logService;
    protected static final Map<CloudConfig, CloudConfigHandler> configHandlerMap;
    protected static final Map<CloudEvent, CloudEventHandler> eventHandlerMap;

    public static void register(CloudConfig anno, CloudConfigHandler handler) {
        configHandlerMap.put(anno, handler);
    }

    public static void register(CloudEvent anno, CloudEventHandler handler) {
        eventHandlerMap.put(anno, handler);
    }

    public static void register(CloudConfigService service) {
        configService = service;
    }

    public static void register(CloudDiscoveryService service) {
        discoveryService = service;
    }

    public static void register(CloudEventService service) {
        eventService = service;
    }

    public static void register(CloudLogService service) {
        logService = service;
    }

    protected static CloudConfigService configService() {
        return configService;
    }

    protected static CloudDiscoveryService discoveryService() {
        return discoveryService;
    }

    protected static CloudEventService eventService() {
        return eventService;
    }

    protected static CloudLogService logService() {
        return logService;
    }

    static {
        configHandlerMap = new LinkedHashMap<CloudConfig, CloudConfigHandler>();
        eventHandlerMap = new LinkedHashMap<CloudEvent, CloudEventHandler>();
    }
}

