/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.utils.LocalUtils;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;

public class Instance
implements Serializable {
    private String service;
    private String address;
    private String serviceAndAddress;
    private String protocol;
    private transient String _uri;
    private double weight = 1.0;
    private Map<String, String> meta = new HashMap<String, String>();
    private List<String> tags;
    private static Instance local;

    public String service() {
        return this.service;
    }

    public String address() {
        return this.address;
    }

    public String serviceAndAddress() {
        if (this.serviceAndAddress == null) {
            this.serviceAndAddress = this.service() + "@" + this.address();
        }
        return this.serviceAndAddress;
    }

    public String protocol() {
        return this.protocol;
    }

    public Instance protocol(String protocol) {
        if (Utils.isNotEmpty((String)protocol)) {
            this.protocol = protocol;
            this._uri = null;
        }
        return this;
    }

    public String uri() {
        if (this._uri == null) {
            this._uri = Utils.isEmpty((String)this.protocol) ? "http://" + this.address : this.protocol + "://" + this.address;
        }
        return this._uri;
    }

    public double weight() {
        return this.weight;
    }

    public Instance weight(double weight) {
        this.weight = weight;
        return this;
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    public Instance metaPut(String name, String value) {
        if (value != null) {
            this.meta.put(name, value);
        }
        return this;
    }

    public String metaGet(String name) {
        return this.meta.get(name);
    }

    public Instance metaPutAll(Map<String, String> map) {
        if (map != null) {
            this.meta.putAll(map);
            this.protocol(map.get("protocol"));
        }
        return this;
    }

    public Instance metaRemove(String name) {
        this.meta.remove(name);
        return this;
    }

    public List<String> tags() {
        return this.tags;
    }

    public Instance tagsAdd(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tag);
        return this;
    }

    public Instance tagsAddAll(Collection<String> list) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.addAll(list);
        return this;
    }

    public Instance() {
    }

    public Instance(String service, String address) {
        this.service = Utils.isEmpty((String)service) ? Solon.cfg().appName() : service;
        this.address = address;
    }

    public static Instance local() {
        if (local == null) {
            String _imageHost = Solon.cfg().serverImageHost(false);
            int _imagePort = Solon.cfg().serverImagePort(false);
            local = Instance.localNew((Signal)new SignalSim(Solon.cfg().appName(), _imageHost, _imagePort, "http", SignalType.HTTP));
        }
        return local;
    }

    public static Instance localNew(Signal signal) {
        Instance n1 = null;
        n1 = Utils.isEmpty((String)signal.host()) ? new Instance(signal.name(), LocalUtils.getLocalAddress() + ":" + signal.port()) : new Instance(signal.name(), signal.host() + ":" + signal.port());
        n1.protocol(signal.protocol());
        n1.metaPutAll((Map<String, String>)Solon.cfg().argx());
        n1.metaRemove("server.port");
        n1.metaPut("protocol", signal.protocol());
        n1.tagsAdd("solon");
        if (Utils.isNotEmpty((String)Solon.cfg().appGroup())) {
            n1.tagsAdd(Solon.cfg().appGroup());
        }
        if (Utils.isNotEmpty((String)Solon.cfg().appName())) {
            n1.tagsAdd(Solon.cfg().appName());
        }
        return n1;
    }
}

