/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.tracing;

import io.opentracing.Tracer;
import org.noear.nami.NamiManager;
import org.noear.solon.Solon;
import org.noear.solon.cloud.tracing.annotation.Tracing;
import org.noear.solon.cloud.tracing.annotation.TracingInterceptor;
import org.noear.solon.cloud.tracing.integration.ErrorListenerTracing;
import org.noear.solon.cloud.tracing.integration.NamiFilterTracing;
import org.noear.solon.cloud.tracing.integration.SolonFilterTracing;
import org.noear.solon.cloud.tracing.service.TracerFactory;
import org.noear.solon.core.Aop;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.util.PrintUtil;

public class TracingManager {
    private static boolean enabled;

    public static synchronized void enable(String excluded) {
        if (enabled) {
            return;
        }
        enabled = true;
        NamiManager.reg((org.noear.nami.Filter)new NamiFilterTracing());
        Solon.global().filter((Filter)new SolonFilterTracing(excluded));
        Solon.global().onError((EventListener)new ErrorListenerTracing());
        Aop.context().beanAroundAdd(Tracing.class, (Interceptor)new TracingInterceptor());
    }

    public static synchronized void register(TracerFactory service) {
        try {
            Aop.wrapAndPut(Tracer.class, (Object)service.create());
            PrintUtil.info((String)"Cloud", (Object)("TracerFactoryService registered from the " + service.getClass().getTypeName()));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

