/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import org.noear.solon.cloud.gateway.CloudGatewayCompletion;
import org.noear.solon.cloud.gateway.CloudGatewayConfiguration;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilterChainImpl;
import org.noear.solon.cloud.gateway.route.Route;
import org.noear.solon.core.exception.StatusException;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;

public class CloudGateway
implements Handler<HttpServerRequest> {
    private CloudGatewayConfiguration configuration = new CloudGatewayConfiguration();

    public void handle(HttpServerRequest request) {
        ExContext ctx = new ExContext(request);
        new ExFilterChainImpl(this.configuration.filters, this::doHandle).doFilter(ctx).subscribe((Subscriber)new CloudGatewayCompletion(ctx, request));
    }

    private Mono<Void> doHandle(ExContext ctx) {
        Route route = this.findRoute(ctx);
        if (route == null) {
            ctx.newResponse().status(404);
            return Mono.empty();
        }
        try {
            return new ExFilterChainImpl(route.getFilters(), this.configuration.routeHandler::handle).doFilter(ctx);
        }
        catch (Throwable ex) {
            if (ex instanceof StatusException) {
                return Mono.error((Throwable)ex);
            }
            return Mono.error((Throwable)new StatusException(ex, 400));
        }
    }

    private Route findRoute(ExContext ctx) {
        for (Route r : this.configuration.routes) {
            if (!r.matched(ctx)) continue;
            ctx.bind(r);
            return r;
        }
        return null;
    }

    public CloudGatewayConfiguration getConfiguration() {
        return this.configuration;
    }
}

