/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route;

import java.net.URI;
import org.noear.solon.cloud.gateway.route.Route;
import org.noear.solon.cloud.gateway.route.RouteHandler;
import org.noear.solon.cloud.gateway.route.RouteRequest;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.net.http.HttpUtils;
import org.noear.solon.util.KeyValues;
import reactor.core.publisher.Mono;

public class SimpleRouteHandler
implements RouteHandler {
    public Mono<Void> handle(Context ctx) {
        HttpUtils httpUtils;
        Route route = Route.of(ctx);
        RouteRequest request = RouteRequest.of(ctx);
        URI uri = route.getTarget();
        if ("lb".equals(uri.getScheme())) {
            httpUtils = HttpUtils.http((String)uri.getHost(), (String)request.getPathAndQueryString());
        } else {
            String url = uri + request.getPathAndQueryString();
            httpUtils = HttpUtils.http((String)url);
        }
        try {
            for (KeyValues keyValues : request.getHeaders().values()) {
                for (String val : keyValues.getValues()) {
                    httpUtils.headerAdd(keyValues.getKey(), val);
                }
            }
            httpUtils.bodyRaw(request.getBody(), request.getContentType());
            return Mono.create(monoSink -> httpUtils.execAsync(request.getMethod(), (isSuccessful, resp, error) -> {
                try {
                    if (resp != null) {
                        ctx.status(resp.code());
                        ctx.contentType(resp.contentType());
                        for (String name : resp.headerNames()) {
                            for (String v : resp.headers(name)) {
                                ctx.headerAdd(name, v);
                            }
                        }
                        ctx.output(resp.body());
                        monoSink.success();
                    } else {
                        monoSink.error((Throwable)error);
                    }
                }
                catch (Throwable ex) {
                    monoSink.error(ex);
                }
            }));
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)new StatusException(ex, 400));
        }
    }
}

