/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.route.RouteFilterFactory;
import org.noear.solon.cloud.gateway.route.RoutePredicateFactory;
import org.noear.solon.cloud.gateway.route.filter.StripPrefixFilterFactory;
import org.noear.solon.cloud.gateway.route.redicate.PathPredicateFactory;

public class RouteFactoryManager {
    private static final RouteFactoryManager global = new RouteFactoryManager();
    private Map<String, RouteFilterFactory> filterFactoryMap = new HashMap<String, RouteFilterFactory>();
    private Map<String, RoutePredicateFactory> predicateFactoryMap = new HashMap<String, RoutePredicateFactory>();

    public static RouteFactoryManager global() {
        return global;
    }

    public void addFactory(RouteFilterFactory factory) {
        this.filterFactoryMap.put(factory.prefix(), factory);
    }

    public void addFactory(RoutePredicateFactory factory) {
        this.predicateFactoryMap.put(factory.prefix(), factory);
    }

    public ExFilter getFilter(String prefix, String config) {
        RouteFilterFactory factory = this.filterFactoryMap.get(prefix);
        if (factory == null) {
            return null;
        }
        return factory.create(config);
    }

    public ExPredicate getPredicate(String prefix, String config) {
        RoutePredicateFactory factory = this.predicateFactoryMap.get(prefix);
        if (factory == null) {
            return null;
        }
        return factory.create(config);
    }

    public ExPredicate buildPredicate(String predicateStr) {
        int idx = predicateStr.indexOf(61);
        if (idx > 0) {
            String prefix = predicateStr.substring(0, idx);
            String config = predicateStr.substring(idx + 1, predicateStr.length());
            return RouteFactoryManager.global().getPredicate(prefix, config);
        }
        return null;
    }

    public ExFilter buildFilter(String filterStr) {
        int idx = filterStr.indexOf(61);
        if (idx > 0) {
            String prefix = filterStr.substring(0, idx);
            String config = filterStr.substring(idx + 1, filterStr.length());
            return RouteFactoryManager.global().getFilter(prefix, config);
        }
        return null;
    }

    static {
        global.addFactory(new PathPredicateFactory());
        global.addFactory(new StripPrefixFilterFactory());
    }
}

