/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.jedis;

import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.noear.solon.Utils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.ScanParams;

class RedisX {
    private JedisPool _jedisPool;

    protected RedisX(Properties prop, String server, String password, int db, int maxTotaol) {
        int maxIdle;
        JedisPoolConfig config = new JedisPoolConfig();
        if (db < 0) {
            db = 0;
        }
        if (maxTotaol < 20) {
            maxTotaol = 200;
        }
        if ((maxIdle = maxTotaol / 100) < 5) {
            maxIdle = 5;
        }
        config.setMaxTotal(maxTotaol);
        config.setMaxIdle(maxIdle);
        config.setTestOnBorrow(false);
        config.setTestOnReturn(false);
        Utils.injectProperties((Object)config, (Properties)prop);
        String[] ss = server.split(":");
        if ("".equals(password)) {
            password = null;
        }
        this._jedisPool = new JedisPool((GenericObjectPoolConfig)config, ss[0], Integer.parseInt(ss[1]), 3000, password, db);
    }

    private RedisUsing doOpen() {
        Jedis jx = this._jedisPool.getResource();
        return new RedisUsing(jx);
    }

    public void open0(Consumer<RedisUsing> using) {
        try (RedisUsing ru = this.doOpen();){
            using.accept(ru);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T open1(Function<RedisUsing, T> using) {
        T temp;
        try (RedisUsing ru = this.doOpen();){
            temp = using.apply(ru);
        }
        return temp;
    }

    public class RedisUsing {
        public Object value;
        private Jedis client;
        private String _key;
        private int _seconds;
        private boolean _close = false;

        private RedisUsing(Jedis c) {
            this.client = c;
        }

        public RedisUsing key(String key) {
            this._key = key;
            return this;
        }

        public RedisUsing expire(int seconds) {
            this._seconds = seconds;
            return this;
        }

        public List<String> scan(String keyPattern, int count) {
            String cursor = ScanParams.SCAN_POINTER_START;
            ScanParams p = new ScanParams();
            p.count(Integer.valueOf(count));
            p.match(keyPattern);
            return this.client.scan(cursor, p).getResult();
        }

        public boolean match(String keyPattern) {
            List<String> temp = this.scan(keyPattern, 1);
            return temp != null && temp.size() > 0;
        }

        public Boolean exists() {
            return this.client.exists(this._key);
        }

        public Boolean delete() {
            return this.client.del(this._key) > 0L;
        }

        public void rename(String newKey) {
            this.client.rename(this._key, newKey);
        }

        public void close() {
            if (this._close) {
                return;
            }
            this.client.close();
            this._close = true;
        }

        private void reset_expire() {
            if (this._seconds > 0) {
                this.client.expire(this._key, this._seconds);
            }
            if (this._seconds < 0) {
                this.client.expire(this._key, -1);
            }
        }

        public void delay() {
            this.reset_expire();
        }

        public RedisUsing set(String val) {
            this.client.set(this._key, val);
            this.reset_expire();
            return this;
        }

        public String get() {
            return this.client.get(this._key);
        }
    }
}

