/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.websocket.WsServer;
import org.noear.solon.boot.websocket._SessionManagerImpl;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.socketd.SessionManager;

public class XPluginImp
implements Plugin {
    private WsServer _server = null;

    public static String solon_boot_ver() {
        return "org.java_websocket 1.5.0/" + Solon.cfg().version();
    }

    public void start(SolonApp app) {
        if (!app.enableWebSocket()) {
            return;
        }
        SessionManager.register((SessionManager)new _SessionManagerImpl());
        String _name = app.cfg().get("server.websocket.name");
        int _port = app.cfg().getInt("server.websocket.port", 0);
        if (_port < 1) {
            _port = 10000 + app.port();
        }
        long time_start = System.currentTimeMillis();
        PrintUtil.info((Object)"solon.server:main: org.java_websocket 1.5.0(websocket)");
        try {
            this._server = new WsServer(_port);
            this._server.start();
            app.signalAdd((Signal)new SignalSim(_name, _port, "ws", SignalType.WEBSOCKET));
            long time_end = System.currentTimeMillis();
            PrintUtil.info((Object)("solon.connector:main: websocket: Started ServerConnector@{HTTP/1.1,[WebSocket]}{0.0.0.0:" + _port + "}"));
            PrintUtil.info((Object)("solon.server:main: websocket: Started @" + (time_end - time_start) + "ms"));
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            PrintUtil.info((Object)("solon.server:main: websocket: Has Stopped " + XPluginImp.solon_boot_ver()));
        }
    }
}

