/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.noear.solon.boot.websocket.WsContextHandler;

public class WsServer
extends WebSocketServer {
    private WsContextHandler _contextHandler;
    private Charset def_charset = Charset.forName("UTF-8");

    public WsServer(int port, WsContextHandler contextHandler) throws UnknownHostException {
        super(new InetSocketAddress(port));
        this._contextHandler = contextHandler;
    }

    public void onStart() {
        System.out.println("WsServer: onStart...");
    }

    public void onOpen(WebSocket conn, ClientHandshake shake) {
        System.out.println("WsServer: onOpen=" + shake.getResourceDescriptor());
    }

    public void onClose(WebSocket conn, int i, String s, boolean b) {
        System.out.println("WsServer: onClose...");
    }

    public void onMessage(WebSocket conn, String data) {
        try {
            this._contextHandler.handle(conn, data.getBytes(this.def_charset), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onMessage(WebSocket conn, ByteBuffer data) {
        try {
            this._contextHandler.handle(conn, data.array(), false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onError(WebSocket conn, Exception ex) {
        System.out.println("WsServer: onError:");
        ex.printStackTrace();
    }
}

