/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import org.noear.solon.boot.undertow.websocket.CallbackImpl;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketBase;

public class WebSocketImpl
extends WebSocketBase {
    private WebSocketChannel real;

    public WebSocketImpl(WebSocketChannel real) {
        this.real = real;
        this.init(URI.create(real.getUrl()));
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress remoteAddress() {
        return this.real.getSourceAddress();
    }

    public InetSocketAddress localAddress() {
        return this.real.getDestinationAddress();
    }

    public long getIdleTimeout() {
        return this.real.getIdleTimeout();
    }

    public void setIdleTimeout(long idleTimeout) {
        this.real.setIdleTimeout(idleTimeout);
    }

    public void send(String text) {
        WebSockets.sendText((String)text, (WebSocketChannel)this.real, CallbackImpl.instance);
    }

    public void send(ByteBuffer binary) {
        WebSockets.sendBinary((ByteBuffer)binary, (WebSocketChannel)this.real, CallbackImpl.instance);
    }

    public void close() {
        super.close();
        RunUtil.runAndTry(() -> ((WebSocketChannel)this.real).close());
    }
}

