/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import org.noear.solon.boot.undertow.websocket.CallbackImpl;
import org.noear.solon.net.websocket.WebSocketBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketImpl
extends WebSocketBase {
    private static final Logger log = LoggerFactory.getLogger(WebSocketImpl.class);
    private WebSocketChannel real;

    public WebSocketImpl(WebSocketChannel real) {
        this.real = real;
        this.init(URI.create(real.getUrl()));
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress remoteAddress() {
        return this.real.getSourceAddress();
    }

    public InetSocketAddress localAddress() {
        return this.real.getDestinationAddress();
    }

    public void send(String text) {
        WebSockets.sendText((String)text, (WebSocketChannel)this.real, CallbackImpl.instance);
    }

    public void send(ByteBuffer binary) {
        WebSockets.sendBinary((ByteBuffer)binary, (WebSocketChannel)this.real, CallbackImpl.instance);
    }

    public void close() {
        block2: {
            super.close();
            try {
                this.real.close();
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("{}", (Throwable)e);
            }
        }
    }
}

