/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.websockets.WebSocketConnectionCallback;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.ssl.SslContextFactory;
import org.noear.solon.boot.undertow.UndertowServerBase;
import org.noear.solon.boot.undertow.http.UtHandlerHandler;
import org.noear.solon.boot.undertow.websocket.UtWsConnectionCallback;
import org.noear.solon.boot.undertow.websocket._SessionManagerImpl;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.socketd.SessionManager;

class UndertowServer
extends UndertowServerBase
implements ServerLifecycle {
    protected Undertow _server;

    UndertowServer() {
    }

    public void start(String host, int port) {
        try {
            this.setup(Solon.app(), host, port);
            this._server.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }

    protected void setup(SolonApp app, String host, int port) throws Throwable {
        HttpHandler httpHandler = this.buildHandler();
        Undertow.Builder builder = Undertow.builder();
        builder.setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false);
        if (ServerProps.request_maxHeaderSize != 0) {
            builder.setServerOption(UndertowOptions.MAX_HEADER_SIZE, (Object)ServerProps.request_maxHeaderSize);
        }
        if (ServerProps.request_maxFileSize != 0) {
            builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)ServerProps.request_maxFileSize);
        }
        builder.setIoThreads(this.props.getCoreThreads());
        if (this.props.isIoBound()) {
            builder.setWorkerThreads(this.props.getMaxThreads(true));
        } else {
            builder.setWorkerThreads(this.props.getMaxThreads(false));
        }
        if (Utils.isEmpty((String)host)) {
            host = "0.0.0.0";
        }
        if (System.getProperty("javax.net.ssl.keyStore") == null) {
            builder.addHttpListener(port, host);
        } else {
            builder.addHttpsListener(port, host, SslContextFactory.create());
        }
        if (app.enableWebSocket()) {
            builder.setHandler((HttpHandler)Handlers.websocket((WebSocketConnectionCallback)new UtWsConnectionCallback(), (HttpHandler)httpHandler));
            SessionManager.register((SessionManager)new _SessionManagerImpl());
        } else {
            builder.setHandler(httpHandler);
        }
        EventBus.push((Object)builder);
        this._server = builder.build();
    }

    protected HttpHandler buildHandler() throws Exception {
        DeploymentInfo builder = this.initDeploymentInfo();
        builder.addServlet(new ServletInfo("ACTServlet", UtHandlerHandler.class).addMapping("/"));
        ServletContainer container = Servlets.defaultContainer();
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        return manager.start();
    }
}

