/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.noear.solon.boot.undertow.ssl.DummyTrustManager;

public class SslContextFactory {
    public static final TrustManager[] TRUST_ALL_CERTS = new X509TrustManager[]{new DummyTrustManager()};

    public static SSLContext createSslContext() throws IOException {
        SSLContext sslContext;
        String keyStoreName = System.getProperty("javax.net.ssl.keyStore");
        String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
        String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
        KeyStore keyStore = SslContextFactory.loadKeyStore(keyStoreName, keyStoreType, keyStorePassword);
        KeyManager[] keyManagers = SslContextFactory.buildKeyManagers(keyStore, keyStorePassword.toCharArray());
        TrustManager[] trustManagers = SslContextFactory.buildTrustManagers(null);
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException exc) {
            throw new IOException("Unable to create and initialise the SSLContext", exc);
        }
        return sslContext;
    }

    private static KeyStore loadKeyStore(String location, String type, String storePassword) throws IOException {
        String url = location;
        if (url.indexOf(58) == -1) {
            url = "file:" + location;
        }
        try (InputStream stream = new URL(url).openStream();){
            KeyStore loadedKeystore = KeyStore.getInstance(type);
            loadedKeystore.load(stream, storePassword.toCharArray());
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
    }

    private static TrustManager[] buildTrustManagers(KeyStore trustStore) throws IOException {
        TrustManager[] trustManagers = null;
        if (trustStore == null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            catch (KeyStoreException | NoSuchAlgorithmException exc) {
                throw new IOException("Unable to initialise TrustManager[]", exc);
            }
        } else {
            trustManagers = TRUST_ALL_CERTS;
        }
        return trustManagers;
    }

    private static KeyManager[] buildKeyManagers(KeyStore keyStore, char[] storePassword) throws IOException {
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, storePassword);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException exc) {
            throw new IOException("Unable to initialise KeyManager[]", exc);
        }
        return keyManagers;
    }
}

