/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.extend.xsocket.SessionBase;

public class _SocketSession
extends SessionBase {
    public static Map<WebSocketChannel, Session> sessions = new HashMap<WebSocketChannel, Session>();
    WebSocketChannel real;
    private String _sessionId = Utils.guid();
    private String _path;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(WebSocketChannel real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            WebSocketChannel webSocketChannel = real;
            synchronized (webSocketChannel) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new _SocketSession(real);
                    sessions.put(real, (Session)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(WebSocketChannel real) {
        sessions.remove(real);
    }

    public _SocketSession(WebSocketChannel real) {
        this.real = real;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.WEBSOCKET;
    }

    public String path() {
        if (this._path == null) {
            this._path = URI.create(this.real.getUrl()).getPath();
        }
        return this._path;
    }

    public void send(String message) {
        WebSockets.sendText((String)message, (WebSocketChannel)this.real, null);
    }

    public void send(byte[] message) {
        ByteBuffer buf = ByteBuffer.wrap(message);
        WebSockets.sendBinary((ByteBuffer)buf, (WebSocketChannel)this.real, null);
    }

    public void send(Message message) {
        this.send(message.content());
    }

    public void close() throws IOException {
        this.real.close();
        sessions.remove(this.real);
    }

    public boolean isValid() {
        return this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.real.getSourceAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.real.getDestinationAddress();
    }

    public void setAttachment(Object obj) {
        this.real.setAttribute("attachment", obj);
    }

    public <T> T getAttachment() {
        return (T)this.real.getAttribute("attachment");
    }

    public Collection<Session> getOpenSessions() {
        return new ArrayList<Session>(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketSession that = (_SocketSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

