/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.websockets.WebSocketConnectionCallback;
import org.noear.solon.XApp;
import org.noear.solon.boot.undertow.XPluginUndertowBase;
import org.noear.solon.boot.undertow.XServerProp;
import org.noear.solon.boot.undertow.http.UtHttpHandlerJsp;
import org.noear.solon.boot.undertow.websocket.UtWsConnectionCallback;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XPlugin;

public class XPluginUndertow
extends XPluginUndertowBase
implements XPlugin {
    Undertow _server;

    public void start(XApp app) {
        try {
            this.setup(app);
            this._server.start();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }

    protected void setup(XApp app) throws Throwable {
        HttpHandler httpHandler = this.buildHandler();
        Undertow.Builder builder = Undertow.builder();
        builder.setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false);
        builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)XServerProp.request_maxRequestSize);
        builder.addHttpListener(app.port(), "0.0.0.0");
        if (app.enableWebSocket()) {
            builder.setHandler((HttpHandler)Handlers.websocket((WebSocketConnectionCallback)new UtWsConnectionCallback(), (HttpHandler)httpHandler));
        } else {
            builder.setHandler(httpHandler);
        }
        XEventBus.push((Object)builder);
        this._server = builder.build();
    }

    protected HttpHandler buildHandler() throws Exception {
        DeploymentInfo builder = this.initDeploymentInfo();
        builder.addServlet(new ServletInfo("ACTServlet", UtHttpHandlerJsp.class).addMapping("/"));
        ServletContainer container = Servlets.defaultContainer();
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        return manager.start();
    }
}

