/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.jsp.HackInstanceManager;
import io.undertow.jsp.JspServletBuilder;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.DefaultClassIntrospector;
import io.undertow.websockets.WebSocketConnectionCallback;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.servlet.MultipartConfigElement;
import org.apache.jasper.deploy.TagLibraryInfo;
import org.apache.tomcat.InstanceManager;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.boot.undertow.XServerProp;
import org.noear.solon.boot.undertow.http.UtHttpHandlerJsp;
import org.noear.solon.boot.undertow.jsp.JspResourceManager;
import org.noear.solon.boot.undertow.jsp.JspServletEx;
import org.noear.solon.boot.undertow.jsp.JspTldLocator;
import org.noear.solon.boot.undertow.websocket.UtWsConnectionCallback;
import org.noear.solon.core.XClassLoader;
import org.noear.solon.core.XPlugin;

public class XPluginUndertowJsp
implements XPlugin {
    private static Undertow _server = null;

    public void start(XApp app) {
        try {
            this.setup(app);
            _server.start();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void setup(XApp app) throws Throwable {
        DeploymentManager manager = this.doGenerateManager();
        HttpHandler httpHandler = manager.start();
        Undertow.Builder builder = Undertow.builder();
        builder.setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false);
        builder.addHttpListener(app.port(), "0.0.0.0");
        if (app.enableWebSocket()) {
            builder.setHandler((HttpHandler)Handlers.websocket((WebSocketConnectionCallback)new UtWsConnectionCallback(), (HttpHandler)httpHandler));
        } else {
            builder.setHandler(httpHandler);
        }
        _server = builder.build();
    }

    private DeploymentManager doGenerateManager() throws Exception {
        MultipartConfigElement configElement = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
        String fileRoot = this.getResourceRoot();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(XPluginUndertowJsp.class.getClassLoader()).setDeploymentName("solon").setContextPath("/").setDefaultEncoding(XServerProp.encoding_request).setDefaultMultipartConfig(configElement).setClassIntrospecter((ClassIntrospecter)DefaultClassIntrospector.INSTANCE);
        builder.setResourceManager((ResourceManager)new JspResourceManager((ClassLoader)XClassLoader.global(), fileRoot)).addServlet(new ServletInfo("ACTServlet", UtHttpHandlerJsp.class).addMapping("/")).addServlet(JspServletEx.createServlet("JSPServlet", "*.jsp"));
        if (XServerProp.session_timeout > 0) {
            builder.setDefaultSessionTimeout(XServerProp.session_timeout);
        }
        HashMap<String, TagLibraryInfo> tagLibraryMap = JspTldLocator.createTldInfos("WEB-INF");
        JspServletBuilder.setupDeployment((DeploymentInfo)builder, new HashMap(), tagLibraryMap, (InstanceManager)new HackInstanceManager());
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentManager deploymentManager = container.addDeployment(builder);
        deploymentManager.deploy();
        return deploymentManager;
    }

    public void stop() throws Throwable {
        if (_server != null) {
            _server.stop();
            _server = null;
        }
    }

    private String getResourceRoot() throws FileNotFoundException {
        URL rootURL = this.getRootPath();
        if (rootURL == null) {
            throw new FileNotFoundException("Unable to find root");
        }
        String resURL = rootURL.toString();
        boolean isDebug = XApp.cfg().isDebugMode();
        if (isDebug && !resURL.startsWith("jar:")) {
            int endIndex = resURL.indexOf("target");
            return resURL.substring(0, endIndex) + "src/main/resources/";
        }
        return "";
    }

    private URL getRootPath() {
        URL root = XUtil.getResource((String)"/");
        if (root != null) {
            return root;
        }
        try {
            String path = XUtil.getResource((String)"").toString();
            if (!path.startsWith("jar:")) {
                return null;
            }
            int endIndex = path.indexOf("!");
            path = path.substring(0, endIndex + 1) + "/";
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

