/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.util.DefaultClassIntrospector;
import io.undertow.websockets.WebSocketConnectionCallback;
import javax.servlet.MultipartConfigElement;
import org.noear.solon.XApp;
import org.noear.solon.boot.undertow.XPluginImp;
import org.noear.solon.boot.undertow.XServerProp;
import org.noear.solon.boot.undertow.http.UtHttpHandler;
import org.noear.solon.boot.undertow.websocket.UtWsConnectionCallback;
import org.noear.solon.core.XPlugin;

public class XPluginUndertow
implements XPlugin {
    private Undertow _server = null;

    public void start(XApp app) {
        try {
            this.setup(app);
            this._server.start();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void setup(XApp app) throws Throwable {
        DeploymentManager manager = this.doGenerateManager();
        HttpHandler httpHandler = manager.start();
        Undertow.Builder builder = Undertow.builder();
        builder.setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false);
        builder.addHttpListener(app.port(), "0.0.0.0");
        if (app.enableWebSocket()) {
            builder.setHandler((HttpHandler)Handlers.websocket((WebSocketConnectionCallback)new UtWsConnectionCallback(), (HttpHandler)httpHandler));
        } else {
            builder.setHandler(httpHandler);
        }
        this._server = builder.build();
    }

    private DeploymentManager doGenerateManager() {
        UtHttpHandler handler = new UtHttpHandler();
        MultipartConfigElement configElement = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(XPluginImp.class.getClassLoader()).setDeploymentName("solon").setContextPath("/").setDefaultEncoding(XServerProp.encoding_request).setDefaultMultipartConfig(configElement).setClassIntrospecter((ClassIntrospecter)DefaultClassIntrospector.INSTANCE);
        builder.addInnerHandlerChainWrapper(h -> handler);
        if (XServerProp.session_timeout > 0) {
            builder.setDefaultSessionTimeout(XServerProp.session_timeout);
        }
        ServletContainer container = Servlets.defaultContainer();
        DeploymentManager deploymentManager = container.addDeployment(builder);
        deploymentManager.deploy();
        return deploymentManager;
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }
}

