/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.websocket;

import java.nio.ByteBuffer;
import org.noear.solon.boot.smarthttp.websocket.WebSocketImpl;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.http.server.WebSocketRequest;
import org.smartboot.http.server.WebSocketResponse;
import org.smartboot.http.server.handler.WebSocketDefaultHandler;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.impl.WebSocketRequestImpl;
import org.smartboot.socket.util.AttachKey;
import org.smartboot.socket.util.Attachment;

public class SmWebSocketHandleImpl
extends WebSocketDefaultHandler {
    static final Logger log = LoggerFactory.getLogger(SmWebSocketHandleImpl.class);
    static final AttachKey<WebSocketImpl> SESSION_KEY = AttachKey.valueOf((String)"SESSION");
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public void onHandShake(WebSocketRequest request, WebSocketResponse response) {
        WebSocketImpl webSokcet = new WebSocketImpl(request);
        if (request.getAttachment() == null) {
            request.setAttachment(new Attachment());
        }
        request.getAttachment().put(SESSION_KEY, (Object)webSokcet);
        this.webSocketRouter.getListener().onOpen((WebSocket)webSokcet);
    }

    public void onClose(Request request) {
        WebSocketRequestImpl request2 = request.newWebsocketRequest();
        this.onCloseDo((WebSocketRequest)request2);
    }

    public void onClose(WebSocketRequest request, WebSocketResponse response) {
        this.onCloseDo(request);
    }

    private void onCloseDo(WebSocketRequest request) {
        WebSocketImpl webSocket = (WebSocketImpl)((Object)request.getAttachment().get(SESSION_KEY));
        if (webSocket.isClosed()) {
            return;
        }
        webSocket.close();
        this.webSocketRouter.getListener().onClose((WebSocket)webSocket);
    }

    public void handleTextMessage(WebSocketRequest request, WebSocketResponse response, String data) {
        try {
            WebSocket webSocket = (WebSocket)request.getAttachment().get(SESSION_KEY);
            this.webSocketRouter.getListener().onMessage(webSocket, data);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void handleBinaryMessage(WebSocketRequest request, WebSocketResponse response, byte[] data) {
        try {
            WebSocket webSocket = (WebSocket)request.getAttachment().get(SESSION_KEY);
            this.webSocketRouter.getListener().onMessage(webSocket, ByteBuffer.wrap(data));
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void onError(WebSocketRequest request, Throwable error) {
        try {
            WebSocket webSocket = (WebSocket)request.getAttachment().get(SESSION_KEY);
            this.webSocketRouter.getListener().onError(webSocket, error);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }
}

