/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp;

import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.smarthttp.http.SmHttpContextHandler;
import org.noear.solon.boot.smarthttp.websocket.SmWebSocketHandleImp;
import org.noear.solon.boot.smarthttp.websocket._SessionManagerImpl;
import org.noear.solon.boot.ssl.SslContextFactory;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.socketd.SessionManager;
import org.smartboot.http.server.HttpBootstrap;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.impl.Request;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.extension.plugins.SslPlugin;

public class SmHttpServer
implements ServerLifecycle {
    private HttpBootstrap server = null;
    private Handler handler;
    private int coreThreads;
    private Executor workExecutor;
    private boolean enableWebSocket;

    public void setEnableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setWorkExecutor(Executor executor) {
        this.workExecutor = executor;
    }

    public void setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
    }

    public void start(String host, int port) throws Throwable {
        this.server = new HttpBootstrap();
        HttpServerConfiguration _config = this.server.configuration();
        if (Utils.isNotEmpty((String)host)) {
            _config.host(host);
        }
        if (System.getProperty("javax.net.ssl.keyStore") != null) {
            SSLContext sslContext = SslContextFactory.create();
            SslPlugin sslPlugin = new SslPlugin(() -> sslContext, sslEngine -> sslEngine.setUseClientMode(false));
            _config.addPlugin((Plugin<Request>)sslPlugin);
        }
        _config.bannerEnabled(false);
        _config.readBufferSize(8192);
        _config.threadNum(this.coreThreads);
        if (ServerProps.request_maxHeaderSize != 0) {
            _config.readBufferSize(ServerProps.request_maxHeaderSize);
        }
        if (ServerProps.request_maxBodySize != 0) {
            _config.setMaxFormContentSize(ServerProps.request_maxBodySize);
        }
        EventBus.push((Object)_config);
        SmHttpContextHandler handlerTmp = new SmHttpContextHandler(this.handler);
        handlerTmp.setExecutor(this.workExecutor);
        this.server.httpHandler(handlerTmp);
        if (this.enableWebSocket) {
            this.server.webSocketHandler(new SmWebSocketHandleImp());
            SessionManager.register((SessionManager)new _SessionManagerImpl());
        }
        this.server.setPort(port);
        this.server.start();
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
        }
    }
}

