/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.websocket;

import org.noear.solon.boot.smarthttp.websocket._SocketSession;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.extend.xsocket.ListenerProxy;
import org.smartboot.http.WebSocketRequest;
import org.smartboot.http.WebSocketResponse;
import org.smartboot.http.server.handle.WebSocketDefaultHandle;

public class WebSocketHandleImp
extends WebSocketDefaultHandle {
    @Override
    public void onHandShark(WebSocketRequest request, WebSocketResponse response) {
        ListenerProxy.getGlobal().onOpen((Session)_SocketSession.get(request, response));
    }

    @Override
    public void onClose(WebSocketRequest request, WebSocketResponse response) {
        _SocketSession session = _SocketSession.get(request, response);
        session.onClose();
        ListenerProxy.getGlobal().onClose((Session)session);
        _SocketSession.remove(request);
    }

    @Override
    public void handleTextMessage(WebSocketRequest request, WebSocketResponse response, String data) {
        try {
            _SocketSession session = _SocketSession.get(request, response);
            Message message = Message.wrap((String)request.getRequestURI(), (byte[])data.getBytes("UTF-8"));
            ListenerProxy.getGlobal().onMessage((Session)session, message, true);
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    @Override
    public void handleBinaryMessage(WebSocketRequest request, WebSocketResponse response, byte[] data) {
        try {
            _SocketSession session = _SocketSession.get(request, response);
            Message message = Message.wrap((String)request.getRequestURI(), (byte[])data);
            ListenerProxy.getGlobal().onMessage((Session)session, message, false);
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    @Override
    public void onError(Throwable error) {
    }
}

