/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.extend.socketd.ProtocolManager;
import org.noear.solon.extend.socketd.SessionBase;
import org.smartboot.http.WebSocketRequest;
import org.smartboot.http.WebSocketResponse;
import org.smartboot.http.server.WebSocketRequestImpl;

public class _SocketServerSession
extends SessionBase {
    public static Map<WebSocketRequest, _SocketServerSession> sessions = new HashMap<WebSocketRequest, _SocketServerSession>();
    WebSocketRequest request;
    WebSocketResponse response;
    private String _sessionId = Utils.guid();
    private URI _uri;
    private String _path;
    private boolean isOpen = true;
    private Object _attachment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static _SocketServerSession get(WebSocketRequest req, WebSocketResponse res) {
        _SocketServerSession tmp = sessions.get(req);
        if (tmp == null) {
            WebSocketRequest webSocketRequest = req;
            synchronized (webSocketRequest) {
                tmp = sessions.get(req);
                if (tmp == null) {
                    tmp = new _SocketServerSession(req, res);
                    sessions.put(req, tmp);
                }
            }
        }
        return tmp;
    }

    public static _SocketServerSession getOnly(WebSocketRequest real) {
        return sessions.get(real);
    }

    public static void remove(WebSocketRequest real) {
        sessions.remove(real);
    }

    public _SocketServerSession(WebSocketRequest request, WebSocketResponse response) {
        this.request = request;
        this.response = response;
    }

    public Object real() {
        return this.request;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.WEBSOCKET;
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(((WebSocketRequestImpl)this.request).getRequestURL());
        }
        return this._uri;
    }

    public String path() {
        if (this._path == null) {
            this._path = this.uri().getPath();
        }
        return this._path;
    }

    public void send(String message) {
        if (Solon.global().enableWebSocketD()) {
            this.sendBuffer(ProtocolManager.encode((Message)Message.wrap((String)message)));
        } else {
            this.response.sendTextMessage(message);
            this.response.flush();
        }
    }

    public void send(Message message) {
        super.send(message);
        if (Solon.global().enableWebSocketD()) {
            this.sendBuffer(ProtocolManager.encode((Message)message));
        } else if (message.isString()) {
            this.send(message.bodyAsString());
        } else {
            this.sendBytes(message.body());
        }
    }

    private void sendBuffer(ByteBuffer buffer) {
        if (buffer != null) {
            this.sendBytes(buffer.array());
        }
    }

    private void sendBytes(byte[] message) {
        this.response.sendBinaryMessage(message);
        this.response.flush();
    }

    public void close() throws IOException {
        this.isOpen = false;
        this.response.close();
        sessions.remove(this.request);
    }

    protected void onClose() {
        this.isOpen = false;
    }

    public boolean isValid() {
        return this.isOpen;
    }

    public boolean isSecure() {
        return this.request.getRequestURI().startsWith("wss:");
    }

    public InetSocketAddress getRemoteAddress() {
        return this.request.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.request.getLocalAddress();
    }

    public void setAttachment(Object obj) {
        this._attachment = obj;
    }

    public <T> T getAttachment() {
        return (T)this._attachment;
    }

    public Collection<Session> getOpenSessions() {
        return new ArrayList<_SocketServerSession>(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketServerSession that = (_SocketServerSession)((Object)o);
        return Objects.equals(this.request, that.request);
    }

    public int hashCode() {
        return Objects.hash(this.request);
    }
}

