/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.exception.HttpException;
import org.smartboot.http.logging.RunLogger;
import org.smartboot.http.server.HttpRequestProtocol;
import org.smartboot.http.server.Request;
import org.smartboot.http.server.WebSocketRequestImpl;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.utils.Attachment;
import org.smartboot.socket.transport.AioSession;

public class WebSocketFrameDecoder
implements Decoder {
    @Override
    public Decoder deocde(ByteBuffer byteBuffer, char[] cacheChars, AioSession aioSession, Request request) {
        if (byteBuffer.remaining() < 2) {
            return this;
        }
        byteBuffer.mark();
        byte first = byteBuffer.get();
        byte second = byteBuffer.get();
        boolean mask = (second & 0x80) != 0;
        int length = second & 0x7F;
        if (length == 127) {
            throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
        }
        if (length == 126) {
            if (byteBuffer.remaining() < 2) {
                byteBuffer.reset();
                return this;
            }
            length = Short.toUnsignedInt(byteBuffer.getShort());
        }
        if (length > 16384) {
            throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
        }
        if (byteBuffer.remaining() < (mask ? length + 4 : length)) {
            byteBuffer.reset();
            return this;
        }
        boolean fin = (first & 0x80) != 0;
        int rsv = (first & 0x70) >> 4;
        int opcode = first & 0xF;
        Attachment attachment = (Attachment)aioSession.getAttachment();
        WebSocketRequestImpl webSocketRequest = attachment.get(HttpRequestProtocol.ATTACH_KEY_WS_REQ);
        webSocketRequest.setFrameFinalFlag(fin);
        webSocketRequest.setFrameRsv(rsv);
        webSocketRequest.setFrameOpcode(opcode);
        webSocketRequest.setFrameMasked(mask);
        if (mask) {
            byte[] maskingKey = new byte[4];
            byteBuffer.get(maskingKey);
            this.unmask(byteBuffer, maskingKey);
        }
        byte[] payload = new byte[length];
        byteBuffer.get(payload);
        RunLogger.getLogger().log(Level.FINEST, "read ws data...");
        webSocketRequest.setPayload(payload);
        return fin ? HttpRequestProtocol.WS_FRAME_DECODER : this;
    }

    private void unmask(ByteBuffer frame, byte[] maskingKey) {
        int i = frame.position();
        int end = frame.limit();
        ByteOrder order = frame.order();
        int intMask = (maskingKey[0] & 0xFF) << 24 | (maskingKey[1] & 0xFF) << 16 | (maskingKey[2] & 0xFF) << 8 | maskingKey[3] & 0xFF;
        if (order == ByteOrder.LITTLE_ENDIAN) {
            intMask = Integer.reverseBytes(intMask);
        }
        while (i + 3 < end) {
            int unmasked = frame.getInt(i) ^ intMask;
            frame.putInt(i, unmasked);
            i += 4;
        }
        int j = i;
        while (i < end) {
            frame.put(i, (byte)(frame.get(i) ^ maskingKey[(i - j) % 4]));
            ++i;
        }
    }
}

