/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.nio.ByteBuffer;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.exception.HttpException;
import org.smartboot.http.server.Request;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.HttpProtocolDecoder;
import org.smartboot.http.server.decode.HttpUriQueryDecoder;
import org.smartboot.http.utils.StringUtils;
import org.smartboot.socket.transport.AioSession;

class HttpUriDecoder
implements Decoder {
    private final HttpUriQueryDecoder uriQueryDecoder = new HttpUriQueryDecoder();
    private final HttpProtocolDecoder protocolDecoder = new HttpProtocolDecoder();

    HttpUriDecoder() {
    }

    @Override
    public Decoder deocde(ByteBuffer byteBuffer, char[] cacheChars, AioSession aioSession, Request request) {
        int length = this.scanURI(byteBuffer, cacheChars);
        if (length > 0) {
            String uri = StringUtils.convertToString(cacheChars, 0, length, StringUtils.String_CACHE_URL);
            request.setUri(uri);
            switch (cacheChars[length]) {
                case ' ': {
                    return this.protocolDecoder.deocde(byteBuffer, cacheChars, aioSession, request);
                }
                case '?': {
                    return this.uriQueryDecoder.deocde(byteBuffer, cacheChars, aioSession, request);
                }
            }
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
        return this;
    }

    private int scanURI(ByteBuffer buffer, char[] cacheChars) {
        while ((cacheChars[0] = (char)(buffer.get() & 0xFF)) == ' ') {
        }
        int i = 1;
        while (buffer.hasRemaining()) {
            cacheChars[i] = (char)(buffer.get() & 0xFF);
            if (cacheChars[i] == ' ' || cacheChars[i] == '?') {
                buffer.mark();
                return i;
            }
            ++i;
        }
        buffer.reset();
        return -1;
    }
}

