/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.nio.ByteBuffer;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.exception.HttpException;
import org.smartboot.http.server.Request;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.HttpHeaderEndDecoder;
import org.smartboot.http.utils.CharArray;
import org.smartboot.http.utils.StringUtils;
import org.smartboot.socket.transport.AioSession;

class HttpHeaderDecoder
implements Decoder {
    private final HttpHeaderEndDecoder decoder = new HttpHeaderEndDecoder();
    private final HeaderValueDecoder headerValueDecoder = new HeaderValueDecoder();

    HttpHeaderDecoder() {
    }

    @Override
    public Decoder deocde(ByteBuffer byteBuffer, char[] cacheChars, AioSession aioSession, Request request) {
        if (byteBuffer.remaining() < 2) {
            return this;
        }
        if (byteBuffer.get(byteBuffer.position()) == 13) {
            if (byteBuffer.get(byteBuffer.position() + 1) != 10) {
                throw new HttpException(HttpStatus.BAD_REQUEST);
            }
            byteBuffer.position(byteBuffer.position() + 2);
            return this.decoder.deocde(byteBuffer, cacheChars, aioSession, request);
        }
        int length = StringUtils.scanUntilAndTrim(byteBuffer, (byte)58, cacheChars, true);
        if (length < 0) {
            return this;
        }
        String name = StringUtils.convertToString(cacheChars, 0, length, StringUtils.String_CACHE_HEADER_NAME);
        request.setHeaderTemp(name);
        return this.headerValueDecoder.deocde(byteBuffer, cacheChars, aioSession, request);
    }

    class HeaderValueDecoder
    implements Decoder {
        HeaderValueDecoder() {
        }

        @Override
        public Decoder deocde(ByteBuffer byteBuffer, char[] cacheChars, AioSession aioSession, Request request) {
            CharArray charArray = request.getHeaderValueCache();
            int startIndex = charArray.getWriteIndex();
            int length = StringUtils.scanUntilAndTrim(byteBuffer, (byte)10, charArray.getData(), startIndex, true);
            if (length == -1) {
                return this;
            }
            charArray.setWriteIndex(startIndex + length - 1);
            request.setHeader(startIndex, length - 1);
            return HttpHeaderDecoder.this.deocde(byteBuffer, cacheChars, aioSession, request);
        }
    }
}

