/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.util.logging.Level;
import org.smartboot.http.HttpRequest;
import org.smartboot.http.HttpResponse;
import org.smartboot.http.WebSocketRequest;
import org.smartboot.http.WebSocketResponse;
import org.smartboot.http.enums.YesNoEnum;
import org.smartboot.http.logging.RunLogger;
import org.smartboot.http.server.AbstractRequest;
import org.smartboot.http.server.AbstractResponse;
import org.smartboot.http.server.HttpExceptionHandle;
import org.smartboot.http.server.HttpRequestImpl;
import org.smartboot.http.server.HttpRequestProtocol;
import org.smartboot.http.server.RFC2612RequestHandle;
import org.smartboot.http.server.Request;
import org.smartboot.http.server.WebSocketHandSharkHandle;
import org.smartboot.http.server.WebSocketRequestImpl;
import org.smartboot.http.server.handle.HandlePipeline;
import org.smartboot.http.server.handle.HttpHandle;
import org.smartboot.http.server.handle.Pipeline;
import org.smartboot.http.server.handle.WebSocketHandle;
import org.smartboot.http.utils.AttachKey;
import org.smartboot.http.utils.Attachment;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.transport.AioSession;

public class HttpMessageProcessor
implements MessageProcessor<Request> {
    private final AttachKey<HttpRequestImpl> ATTACH_KEY_HTTP_REQUEST = AttachKey.valueOf("httpRequest");
    private final HandlePipeline<HttpRequest, HttpResponse> httpPipeline = new HandlePipeline();
    private final HandlePipeline<WebSocketRequest, WebSocketResponse> wsPipeline = new HandlePipeline();

    public HttpMessageProcessor() {
        this.httpPipeline.next(new HttpExceptionHandle()).next(new RFC2612RequestHandle());
        this.wsPipeline.next(new WebSocketHandSharkHandle());
    }

    public void process(AioSession session, Request baseHttpRequest) {
        try {
            HandlePipeline<Object, Object> pipeline;
            AbstractResponse response;
            AbstractRequest request;
            Attachment attachment = (Attachment)session.getAttachment();
            if (baseHttpRequest.isWebsocket() == YesNoEnum.Yes) {
                WebSocketRequestImpl webSocketRequest = attachment.get(HttpRequestProtocol.ATTACH_KEY_WS_REQ);
                request = webSocketRequest;
                response = webSocketRequest.getResponse();
                pipeline = this.wsPipeline;
            } else {
                HttpRequestImpl http11Request = attachment.get(this.ATTACH_KEY_HTTP_REQUEST);
                if (http11Request == null) {
                    http11Request = new HttpRequestImpl(baseHttpRequest);
                    attachment.put(this.ATTACH_KEY_HTTP_REQUEST, http11Request);
                }
                request = http11Request;
                response = http11Request.getResponse();
                pipeline = this.httpPipeline;
            }
            pipeline.doHandle((WebSocketRequest)((Object)request), (WebSocketResponse)((Object)response));
            if (!response.getOutputStream().isClosed()) {
                response.getOutputStream().close();
            }
            if (response.isClosed()) {
                session.close(false);
            } else {
                request.reset();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stateEvent(AioSession session, StateMachineEnum stateMachineEnum, Throwable throwable) {
        switch (stateMachineEnum) {
            case NEW_SESSION: {
                Attachment attachment = new Attachment();
                attachment.put(HttpRequestProtocol.ATTACH_KEY_REQUEST, new Request(session));
                session.setAttachment((Object)attachment);
                break;
            }
            case PROCESS_EXCEPTION: {
                RunLogger.getLogger().log(Level.WARNING, "process exception", throwable);
                session.close();
                break;
            }
            case DECODE_EXCEPTION: {
                throwable.printStackTrace();
            }
        }
    }

    public Pipeline<HttpRequest, HttpResponse> pipeline(HttpHandle httpHandle) {
        return this.httpPipeline.next(httpHandle);
    }

    public Pipeline<HttpRequest, HttpResponse> pipeline() {
        return this.httpPipeline;
    }

    public Pipeline<WebSocketRequest, WebSocketResponse> wsPipeline(WebSocketHandle httpHandle) {
        return this.wsPipeline.next(httpHandle);
    }

    public Pipeline<WebSocketRequest, WebSocketResponse> wsPipeline() {
        return this.wsPipeline;
    }
}

